package com.bizunited.platform.task.local.repository;

import com.bizunited.platform.task.local.entity.DynamicTaskParamEntity;

import java.util.List;

import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

/**
 * 动态任务参数信息持久化数据层的处理服务
 * @author yinwenjie
 */
@Repository("DynamicTaskParamRepository")
public interface DynamicTaskParamRepository
        extends
        JpaRepository<DynamicTaskParamEntity, String> ,
        JpaSpecificationExecutor<DynamicTaskParamEntity> {
  
  /**
   * 按照动态任务查询其关联的所有参数
   * @param dynamicTaskId
   * @return
   */
  @Query("from DynamicTaskParamEntity t where t.dynamicTask.id = :dynamicTaskId order by t.paramIndex ")
  public List<DynamicTaskParamEntity> findByDynamicTask(@Param("dynamicTaskId") String dynamicTaskId);
  
  /**
   * 删除指定的动态任务下的所有参数信息
   * @param dynamicTaskId 指定的动态任务
   */
  @Modifying
  @Query(value = "delete from engine_dynamic_params where dynamic_task = :dynamicTaskId " , nativeQuery = true)
  public void deleteByDynamicTask(@Param("dynamicTaskId") String dynamicTaskId);
}