package com.bizunited.platform.task.local.repository.internal;

import com.bizunited.platform.common.repository.PageRepositoryImpl;
import com.bizunited.platform.common.util.tenant.TenantUtils;
import com.bizunited.platform.task.dto.DynamicTaskSchedulerDto;
import com.bizunited.platform.task.local.entity.DynamicTaskSchedulerEntity;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Repository;

import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import java.util.HashMap;
import java.util.Map;

/**
 * @author yinwenjie
 */
@Repository("DynamicTaskSchedulerRepositoryImpl")
public class DynamicTaskSchedulerRepositoryImpl implements DynamicTaskSchedulerRepositoryCustom, PageRepositoryImpl {
  @Autowired
  @PersistenceContext
  private EntityManager entityManager;
  
  @Override
  public Page<DynamicTaskSchedulerEntity> findByConditions(Pageable pageable,  DynamicTaskSchedulerDto conditions) {
    /*
     * -按照任务类型、任务编码、运行状态、任务状态、任务名称进行查询
     * */
    StringBuilder hql = new StringBuilder("from DynamicTaskSchedulerEntity dt where 1 = 1");
    StringBuilder countHql = new StringBuilder("select count(*) from DynamicTaskSchedulerEntity dt where 1 = 1");
    StringBuilder condition = new StringBuilder();
    Map<String, Object> parameters = new HashMap<>();
    //项目筛选
    condition.append(" AND dt.projectName=:projectName ");
    parameters.put("projectName", TenantUtils.getTenantCode());
    // 任务类型
    Integer taskType = conditions.getTaskType();
    if(taskType != null) {
      condition.append(" AND dt.taskType = :taskType ");
      parameters.put("taskType", taskType);
    }
    // 任务编码
    String taskCode = conditions.getTaskCode();
    if(StringUtils.isNotBlank(taskCode)) {
      condition.append(" AND dt.taskCode = :taskCode ");
      parameters.put("taskCode", taskCode);
    }
    // 运行状态
    Integer workingStatus = conditions.getWorkingStatus();
    if (workingStatus != null) {
      condition.append(" AND dt.workingStatus = :workingStatus ");
      parameters.put("workingStatus", workingStatus);
    }
    // 任务状态
    Integer tstatus = conditions.getTstatus();
    if(tstatus != null) {
      condition.append(" AND dt.tstatus = :tstatus ");
      parameters.put("tstatus", tstatus);
    }
    // 任务名称
    String taskDesc = conditions.getTaskDesc();
    if(StringUtils.isNotBlank(taskDesc)) {
      condition.append(" AND dt.taskDesc = :taskDesc ");
      parameters.put("taskDesc", taskDesc);
    }
    // 脚本执行类型
    Integer invokeType = conditions.getInvokeType();
    if(invokeType != null) {
      condition.append(" AND dt.invokeType = :invokeType ");
      parameters.put("invokeType", invokeType);
    }
    // 应用程序名
    String applicationName = conditions.getApplicationName();
    if(StringUtils.isNotBlank(applicationName)) {
      condition.append(" AND dt.applicationName = :applicationName ");
      parameters.put("applicationName", applicationName);
    }
    // appCode，顶层租户名
    String appCode = conditions.getAppCode();
    if(StringUtils.isNotBlank(appCode)) {
      condition.append(" AND dt.appCode = :appCode ");
      parameters.put("appCode", appCode);
    }

    hql.append(condition).append(" order by dt.createTime desc  ");
    countHql.append(condition);
    return queryByConditions(entityManager, hql.toString(), countHql.toString(), parameters, pageable, false, null);
  }
}