package com.bizunited.platform.task.local.service.scheduler;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

import com.bizunited.platform.common.util.tenant.TenantContextHolder;
import com.bizunited.platform.task.service.DynamicTaskSchedulerVoService;

/**
 * 每一个DynamicLoadingTask任务，为指定的applicationName、指定的appCode为管理范围，
 * 周期性保证管理范围内的动态任务执行的正确性
 * @author yinwenjie
 */
@Component("_DynamicLoadingTask")
@Scope("prototype")
@Lazy
public class DynamicLoadingSchedulerTask implements Runnable  {
  /**
   * 该任务设计的一级租户名（应用名）
   */
  private String appCode;
  /**
   * 该任务所涉及的应用程序名
   */
  private String applicationName;
  @Autowired
  private DynamicTaskSchedulerVoService dynamicTaskSchedulerVoService;
  
  /**
   * @param currentTask 
   * @param ctx 
   */
  public DynamicLoadingSchedulerTask(String appCode, String applicationName) {
    this.appCode = appCode;
    this.applicationName = applicationName;
  }
  
  @Override
  public void run() {
    /*
     * 任务只能在获取了特定applicationName_appCode_DynamicTaskLockKey常量的独占操作权的情况下，才能运行
     * 而以上要求由DynamicMasterKeeperTask负责完成。
     * */
    
    // 注意设定和清理TenantContext上下文的时机，以便能查询正确的数据源
    try {
      TenantContextHolder.setApp(appCode);
      this.dynamicTaskSchedulerVoService.loading(applicationName, appCode);
    } finally {
      TenantContextHolder.clean();
    }
  }
}
