package com.bizunited.platform.task.local.service.strategy;

import java.lang.reflect.Type;

import org.springframework.stereotype.Component;

import com.bizunited.platform.task.service.strategy.DynamicTaskParamValueConverter;

/**
 * 这是默认的参数值转换器，专门用来进行八大基本类型的处理。
 * @author yinwenjie
 */
@Component("_DynamicTaskParamValueDefaultConverter")
public class DynamicTaskParamValueDefaultConverter implements DynamicTaskParamValueConverter {

  /**
   * 这是默认的参数消息转换器
   */
  @Override
  public boolean isDefault() {
    return true;
  }

  @Override
  public boolean canConverter(int index, Type paramType) {
    return false;
  }

  @Override
  public String serialize(int index, Type paramType, Object value) {
    return value.toString();
  }

  @Override
  public Object deserialize(int index, Type paramType, String value) {
    if(!paramType.getClass().isAssignableFrom(Class.class)) {
      return paramType.getTypeName();
    }
    
    // 八大类型加序列化字符串
    if(paramType == Integer.class) {
      return Integer.parseInt(value);
    } else if(paramType == Double.class) {
      return Double.parseDouble(value);
    } else if(paramType == Float.class) {
      return Float.parseFloat(value);
    } else if(paramType == Long.class) {
      return Long.parseLong(value);
    } else if(paramType == Short.class) {
      return Short.parseShort(value);
    } else if(paramType == Byte.class) {
      return Byte.parseByte(value);
    } else if(paramType == Boolean.class) {
      return Boolean.parseBoolean(value);
    } else if(paramType == Character.class) {
      return value.charAt(0);
    } 
    return value;
  }
}