package com.bizunited.platform.task.local.service.strategy;

import java.lang.reflect.Type;

import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bizunited.platform.task.service.strategy.DynamicTaskParamValueConverter;

/**
 * 该转换器用来进行业务对象的json信息转换
 * @author yinwenjie
 */
@Component("_DynamicTaskParamValueJsonConverter")
public class DynamicTaskParamValueJsonConverter implements DynamicTaskParamValueConverter {

  @Override
  public boolean canConverter(int index, Type paramType) {
    /*
     * 1、首先该类型不是java基本类型，也不是字符串类型
     * 2、其次它不是集合性质的类
     * 3、其次该类并不是java jdk中的类（包名不是java或者javax开始）
     * */
    // 1、=========
    // 八大类型加序列化字符串
    if(paramType == Integer.class) {
      return false;
    } else if(paramType == Double.class) {
      return false;
    } else if(paramType == Float.class) {
      return false;
    } else if(paramType == Long.class) {
      return false;
    } else if(paramType == Short.class) {
      return false;
    } else if(paramType == Byte.class) {
      return false;
    } else if(paramType == Boolean.class) {
      return false;
    } else if(paramType == Character.class) {
      return false;
    } else if(paramType instanceof CharSequence) {
      return false;
    }
    
    // 2、========
    if(paramType instanceof Iterable) {
      return false;
    }
    
    // 3、========
    String paramClassanme = paramType.getTypeName();
    if(StringUtils.indexOfAny(paramClassanme, "java.","javax.") != -1) {
      return false;
    }
    
    return true;
  }

  @Override
  public String serialize(int index, Type paramType, Object value) { 
    String stringValue = JSONObject.toJSONString(value);
    return stringValue;
  } 

  @Override
  public Object deserialize(int index, Type paramType, String value) {
    return JSONArray.parseObject(value, paramType);
  }
}