package com.bizunited.platform.task.dto;

import io.swagger.annotations.ApiModelProperty;

/**
 * 动态任务的查询条件DTO
 * @author yinwenjie
 */
public class DynamicTaskSchedulerDto {
  /**
   * 任务类型：1、一次性执行；2：周期性执行
   */
  @ApiModelProperty("任务类型：1、一次性执行；2：周期性执行")
  private Integer taskType = 2;
  
  @ApiModelProperty("任务唯一编号（只能由英文、数字、下杠构成）")
  private String taskCode;
  
  @ApiModelProperty("任务状态：0：无效任务；1、有效任务")
  private Integer tstatus = 0;
  
  @ApiModelProperty("工作状态：0：要求运行， 1：要求停止，2：已运行；3、已停止")
  private Integer workingStatus = 0;
  
  @ApiModelProperty("任务中文说明(可模糊查询)")
  private String taskDesc;
  
  @ApiModelProperty("定时器任务内容的执行方式")
  private Integer invokeType;
  
  @ApiModelProperty("应用程序名")
  private String applicationName;
  
  @ApiModelProperty("多应用编码（在一个数据库中，有多个不同的appCode的情况不多，但还是需要支持）")
  private String appCode; 

  public Integer getTaskType() {
    return taskType;
  }

  public void setTaskType(Integer taskType) {
    this.taskType = taskType;
  }

  public String getTaskCode() {
    return taskCode;
  }

  public void setTaskCode(String taskCode) {
    this.taskCode = taskCode;
  }

  public Integer getTstatus() {
    return tstatus;
  }

  public void setTstatus(Integer tstatus) {
    this.tstatus = tstatus;
  }

  public Integer getWorkingStatus() {
    return workingStatus;
  }

  public void setWorkingStatus(Integer workingStatus) {
    this.workingStatus = workingStatus;
  }

  public String getTaskDesc() {
    return taskDesc;
  }

  public void setTaskDesc(String taskDesc) {
    this.taskDesc = taskDesc;
  }

  public Integer getInvokeType() {
    return invokeType;
  }

  public void setInvokeType(Integer invokeType) {
    this.invokeType = invokeType;
  }

  public String getApplicationName() {
    return applicationName;
  }

  public void setApplicationName(String applicationName) {
    this.applicationName = applicationName;
  }

  public String getAppCode() {
    return appCode;
  }

  public void setAppCode(String appCode) {
    this.appCode = appCode;
  }
}
