package com.bizunited.platform.task.dto;

import java.util.Date;

import io.swagger.annotations.ApiModelProperty;

/**
 * 动态任务的查询条件DTO
 * @author yinwenjie
 */
public class DynamicTaskSchedulerLogDto {
  /**
   * 指定的任务技术编号
   */
  @ApiModelProperty("指定的任务技术编号")
  private String taskId;
  
  @ApiModelProperty("是否只查询执行成功或者执行失败的记录")
  private Boolean success;
  
  @ApiModelProperty("执行日志的开始执行时间")
  private Date logtime;
  
  @ApiModelProperty("应用程序名")
  private String applicationName;
  
  @ApiModelProperty("多应用编码（在一个数据库中，有多个不同的appCode的情况不多，但还是需要支持）")
  private String appCode; 

  public String getTaskId() {
    return taskId;
  }

  public void setTaskId(String taskId) {
    this.taskId = taskId;
  }

  public Boolean getSuccess() {
    return success;
  }

  public void setSuccess(Boolean success) {
    this.success = success;
  }

  public Date getLogtime() {
    return logtime;
  }

  public void setLogtime(Date logtime) {
    this.logtime = logtime;
  }

  public String getApplicationName() {
    return applicationName;
  }

  public void setApplicationName(String applicationName) {
    this.applicationName = applicationName;
  }

  public String getAppCode() {
    return appCode;
  }

  public void setAppCode(String appCode) {
    this.appCode = appCode;
  }
}
