package com.bizunited.platform.task.vo;

import com.bizunited.platform.common.vo.UuidVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.Date;

/**
 * 周期性或一次性动态任务的执行日志
 * @author yinwenjie
 */
@ApiModel(value = "DynamicTaskSchedulerLogVo", description = "周期性或一次性动态任务的执行日志")
public class DynamicTaskSchedulerLogVo extends UuidVo {
  /**
   * 
   */
  private static final long serialVersionUID = 7899433204549913269L;
  
  @ApiModelProperty(name="dynamicTaskId" , value="对应的动态任务技术编号", required=true)
  private String dynamicTaskId;
  /**
   * 对应的动态日志
   */
  @ApiModelProperty(name="dynamicTaskScheduler" , value="对应的动态任务业务编号", required=true)
  private String taskCode;
  /**
   * 由于多个微服务中心可能共享一个数据库
   * 那么就存在A服务更新定时任务时，将B服务中心配置的定时任务误操作。
   * 为了避免这个情况，这里可以有扫描程序设定服务名（必须有）
   */
  @ApiModelProperty(name="applicationName" , value="应用程序名", required=true)
  private String applicationName = "default";
  /**
   * 多应用编码（在一个数据库中，有多个不同的appCode的情况不多，但还是需要支持）
   */
  @ApiModelProperty(name="appCode" , value="多应用编码（在一个数据库中，有多个不同的appCode的情况不多，但还是需要支持）", required=true)
  private String appCode;
  /**
   * 执行开始时间
   */
  @ApiModelProperty(name="startTime" , value="执行开始时间", required=true)
  private Date startTime;
  /**
   * 执行结束时间
   */
  @ApiModelProperty(name="endTime" , value="执行结束时间", required=true)
  private Date endTime;
  /**
   * 执行是否成功
   */
  @ApiModelProperty(name="success" , value="执行是否成功", required=true)
  private Boolean success;
  /**
   * 可能的错误日志
   */
  @ApiModelProperty(name="errorContents" , value="可能的错误日志", required=false)
  private String errorContents;
  
  public String getDynamicTaskId() {
    return dynamicTaskId;
  }
  public void setDynamicTaskId(String dynamicTaskId) {
    this.dynamicTaskId = dynamicTaskId;
  }
  public String getTaskCode() {
    return taskCode;
  }
  public void setTaskCode(String taskCode) {
    this.taskCode = taskCode;
  }
  public String getApplicationName() {
    return applicationName;
  }
  public void setApplicationName(String applicationName) {
    this.applicationName = applicationName;
  }
  public String getAppCode() {
    return appCode;
  }
  public void setAppCode(String appCode) {
    this.appCode = appCode;
  }
  public Date getStartTime() {
    return startTime;
  }
  public void setStartTime(Date startTime) {
    this.startTime = startTime;
  }
  public Date getEndTime() {
    return endTime;
  }
  public void setEndTime(Date endTime) {
    this.endTime = endTime;
  }
  public Boolean getSuccess() {
    return success;
  }
  public void setSuccess(Boolean success) {
    this.success = success;
  }
  public String getErrorContents() {
    return errorContents;
  }
  public void setErrorContents(String errorContents) {
    this.errorContents = errorContents;
  }
}