/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.common.config;

import com.bizunited.platform.common.config.RedisCustomProperties;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.connection.RedisStandaloneConfiguration;
import org.springframework.data.redis.connection.jedis.JedisConnectionFactory;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;

@Configuration
public class JedisCustomConfig {
    @Autowired
    private RedisCustomProperties redisCustomProperties;
    private static final Logger LOGGER = LoggerFactory.getLogger(JedisCustomConfig.class);

    @Bean
    @ConditionalOnMissingBean
    public JedisConnectionFactory getJedisConnectionFactory() {
        String firstAddress = this.redisCustomProperties.getAddress()[0];
        String password = this.redisCustomProperties.getPassword();
        String[] address = firstAddress.split(":");
        int database = this.redisCustomProperties.getDatabase();
        RedisStandaloneConfiguration redisStandaloneConfiguration = new RedisStandaloneConfiguration(address[0], Integer.valueOf(address[1]).intValue());
        redisStandaloneConfiguration.setPassword(password);
        redisStandaloneConfiguration.setDatabase(database);
        return new JedisConnectionFactory(redisStandaloneConfiguration);
    }

    @Bean
    @ConditionalOnMissingBean
    public JedisPoolConfig getRedisConfig() {
        JedisPoolConfig config = new JedisPoolConfig();
        return config;
    }

    @Bean
    @ConditionalOnMissingBean
    public JedisPool getJedisPool() {
        JedisPoolConfig config = this.getRedisConfig();
        String firstAddress = this.redisCustomProperties.getAddress()[0];
        String password = this.redisCustomProperties.getPassword();
        int database = this.redisCustomProperties.getDatabase();
        String[] address = firstAddress.split(":");
        JedisPool jp = new JedisPool((GenericObjectPoolConfig)config, address[0], Integer.valueOf(address[1]).intValue(), 60, password, database, false);
        LOGGER.info("\u6b64\u65f6\u83b7\u53d6\u5230JEDIS POLL\uff0c\u5730\u5740:{},\u7aef\u53e3:{},\u5e93\u7d22\u5f15:{}", new Object[]{address[0], address[1], database});
        return jp;
    }
}

