/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.common.repository;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.hibernate.query.internal.NativeQueryImpl;
import org.hibernate.transform.Transformers;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;

public interface PageRepositoryImpl {
    default public <T> Page<T> queryByConditions(EntityManager entityManager, String sql, String countSql, Map<String, Object> parameter, Pageable pageable, boolean nativeQuery, Class<T> resultClazz) {
        Query countQuery;
        Query query;
        if (nativeQuery) {
            Validate.notNull(resultClazz, (String)"resultClazz\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            query = entityManager.createNativeQuery(sql);
            ((NativeQueryImpl)query.unwrap(NativeQueryImpl.class)).setResultTransformer(Transformers.aliasToBean(resultClazz));
            countQuery = entityManager.createNativeQuery(countSql);
        } else {
            query = entityManager.createQuery(sql);
            countQuery = entityManager.createQuery(countSql);
        }
        parameter.forEach((k, v) -> {
            query.setParameter(k, v);
            countQuery.setParameter(k, v);
        });
        query.setFirstResult(pageable.getPageNumber() * pageable.getPageSize());
        query.setMaxResults(pageable.getPageSize());
        long count = nativeQuery ? ((BigInteger)countQuery.getResultList().get(0)).longValue() : ((Long)countQuery.getResultList().get(0)).longValue();
        ArrayList result = count > 0L ? query.getResultList() : new ArrayList();
        return new PageImpl(result, pageable, count);
    }

    default public String getSort(Pageable pageable, Sort defaultSort, String alias) {
        Validate.notNull((Object)defaultSort, (String)"\u9ed8\u8ba4\u6392\u5e8f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Sort sort = pageable.getSortOr(defaultSort);
        if (sort.isUnsorted()) {
            return "";
        }
        Iterator iterator = sort.iterator();
        ArrayList<String> orders = new ArrayList<String>();
        while (iterator.hasNext()) {
            Sort.Order order = (Sort.Order)iterator.next();
            String property = order.getProperty();
            String sql = StringUtils.isBlank((CharSequence)alias) ? property : StringUtils.join((Object[])new String[]{alias, ".", property});
            sql = StringUtils.join((Object[])new String[]{sql, " ", order.getDirection().name()});
            orders.add(sql);
        }
        return StringUtils.join((Object[])new String[]{" order by ", StringUtils.join(orders, (String)",")});
    }
}

