/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.common.util;

import java.nio.charset.StandardCharsets;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Aes128Utils {
    private static final Logger LOGGER = LoggerFactory.getLogger(Aes128Utils.class);
    private static final int KEY_LENGTH = 16;

    private Aes128Utils() {
        throw new UnsupportedOperationException("\u9759\u6001\u5de5\u5177\u7c7b\uff0c\u4e0d\u652f\u6301\u5b9e\u4f8b\u5316");
    }

    private static String getEncodeType(EncodeType encodeType, Padding padding) {
        return StringUtils.join((Object[])new String[]{"AES/", encodeType.getType(), "/", padding.getPadding()});
    }

    public static String encrypt(CharSequence charSequence, String key, EncodeType encodeType, Padding padding) {
        if (StringUtils.isEmpty((CharSequence)charSequence)) {
            return null;
        }
        Validate.notBlank((CharSequence)key, (String)"\u52a0\u5bc6\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)((Object)encodeType), (String)"\u52a0\u5bc6\u6a21\u5f0f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)((Object)padding), (String)"\u586b\u5145\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((key.length() == 16 ? 1 : 0) != 0, (String)"\u5bc6\u7801\u957f\u5ea6\u5fc5\u987b\u4e3a16\u4f4d", (Object[])new Object[0]);
        byte[] bytes = charSequence.toString().getBytes(StandardCharsets.UTF_8);
        byte[] keyBytes = key.getBytes(StandardCharsets.UTF_8);
        SecretKeySpec keySpec = new SecretKeySpec(keyBytes, "AES");
        IvParameterSpec iv = new IvParameterSpec(keyBytes);
        try {
            Cipher cipher = Cipher.getInstance(Aes128Utils.getEncodeType(encodeType, padding));
            cipher.init(1, (Key)keySpec, iv);
            byte[] enBytes = cipher.doFinal(bytes);
            return Base64.encodeBase64String((byte[])enBytes);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    public static String decrypt(CharSequence charSequence, String key, EncodeType encodeType, Padding padding) {
        Validate.notBlank((CharSequence)charSequence, (String)"\u89e3\u5bc6\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)key, (String)"\u52a0\u5bc6\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)((Object)encodeType), (String)"\u52a0\u5bc6\u6a21\u5f0f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)((Object)padding), (String)"\u586b\u5145\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((key.length() == 16 ? 1 : 0) != 0, (String)"\u5bc6\u7801\u957f\u5ea6\u5fc5\u987b\u4e3a16\u4f4d", (Object[])new Object[0]);
        byte[] encodedBytes = Base64.decodeBase64((String)charSequence.toString());
        byte[] keyBytes = key.getBytes(StandardCharsets.UTF_8);
        SecretKeySpec keySpec = new SecretKeySpec(keyBytes, "AES");
        try {
            Cipher cipher = Cipher.getInstance(Aes128Utils.getEncodeType(encodeType, padding));
            IvParameterSpec iv = new IvParameterSpec(keyBytes);
            cipher.init(2, (Key)keySpec, iv);
            byte[] bytes = cipher.doFinal(encodedBytes);
            return new String(bytes, StandardCharsets.UTF_8);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }

    public static enum Padding {
        PKCS_5_PADDING("PKCS5Padding"),
        PKCS_7_PADDING("PKCS7Padding");

        private String padding;

        private Padding(String padding) {
            this.padding = padding;
        }

        public String getPadding() {
            return this.padding;
        }
    }

    public static enum EncodeType {
        ECB("ECB"),
        CBC("CBC");

        private String type;

        private EncodeType(String type) {
            this.type = type;
        }

        public String getType() {
            return this.type;
        }
    }
}

