/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.common.util;

import feign.Response;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FileUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileUtils.class);

    private FileUtils() {
        throw new IllegalStateException("\u9759\u6001\u7c7b\u4e0d\u80fd\u5b9e\u4f8b\u5316");
    }

    public static File writeLocalFile(byte[] bytes, String fileRoot, String fileSuffix) {
        String filePath;
        File folder;
        if (fileRoot == null) {
            fileRoot = "/";
        }
        if (!(folder = new File(filePath = fileRoot + "/tmp")).exists()) {
            folder.mkdirs();
        }
        String tmpFileName = StringUtils.join((Object[])new String[]{UUID.randomUUID().toString(), ".", fileSuffix});
        File file = new File(folder, tmpFileName);
        try {
            Validate.isTrue((boolean)file.createNewFile(), (String)"\u521b\u5efa\u672c\u5730\u6587\u4ef6\u5931\u8d25\uff1a%s", (Object[])new Object[]{file.getAbsolutePath()});
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new IllegalArgumentException(String.format("\u521b\u5efa\u672c\u5730\u6587\u4ef6\u5931\u8d25\uff1a%s", e.getMessage()));
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        try (FileOutputStream fos = new FileOutputStream(file);){
            int realLen;
            int maxLen = 4096;
            byte[] contents = new byte[maxLen];
            while ((realLen = bais.read(contents, 0, maxLen)) != -1) {
                fos.write(contents, 0, realLen);
            }
        }
        catch (FileNotFoundException e) {
            throw new IllegalArgumentException(String.format("\u672a\u627e\u5230\u672c\u5730\u6587\u4ef6\uff1a%s", file.getAbsolutePath()));
        }
        catch (IOException e) {
            throw new IllegalArgumentException(String.format("\u8bfb\u53d6\u672c\u5730\u6587\u4ef6\u5931\u8d25\uff1a%s", e.getMessage()));
        }
        return file;
    }

    /*
     * Exception decompiling
     */
    public static byte[] readByte(Response response) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] readBytes(InputStream inputStream, int readLength) {
        if (inputStream == null) return new byte[0];
        if (readLength < 1) {
            return new byte[0];
        }
        byte[] buffer = new byte[readLength];
        try (ByteArrayOutputStream outByte = new ByteArrayOutputStream();){
            int len;
            while ((len = inputStream.read(buffer, 0, buffer.length)) != -1) {
                outByte.write(buffer, 0, len);
            }
            byte[] byArray = outByte.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return new byte[0];
        }
    }
}

