/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.competence.tacit.local.init;

import com.bizunited.nebula.competence.sdk.service.CompetenceVoService;
import com.bizunited.nebula.competence.tacit.local.repository.DefaultCompetenceRepository;
import com.bizunited.nebula.competence.tacit.local.vo.DefaultCompetenceVo;
import com.bizunited.nebula.init.service.InitProcessEnvironmentService;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.mvc.condition.PatternsRequestCondition;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;
import springfox.documentation.spring.web.ControllerNamingUtils;

@Component(value="frameworkEndpointProcess")
public class FrameworkEndpointInitProcess
implements InitProcessEnvironmentService {
    private static final Logger LOGGER = LoggerFactory.getLogger(FrameworkEndpointInitProcess.class);
    @Autowired
    private RequestMappingHandlerMapping frameworkEndpointHandler;
    @Autowired
    private CompetenceVoService competenceVoService;
    @Autowired
    private DefaultCompetenceRepository defaultCompetenceRepository;

    public int sort() {
        return -1;
    }

    public boolean doInitForAppCode(String appCode) {
        return true;
    }

    @Transactional
    public void initForAppCode(String appCode) {
        this.initFrameworkEndpoint();
    }

    private List<String> getTags(HandlerMethod handlerMethod) {
        Class clazz = handlerMethod.getBeanType();
        Api api = clazz.getAnnotation(Api.class);
        if (api == null) {
            return Lists.newArrayList();
        }
        String[] controllerTags = api.tags();
        return Arrays.stream(controllerTags).filter(tag -> StringUtils.isNotBlank((CharSequence)tag)).collect(Collectors.toList());
    }

    private String getTag(HandlerMethod handlerMethod) {
        List<String> tags = this.getTags(handlerMethod);
        String tag = CollectionUtils.isEmpty(tags) ? ControllerNamingUtils.controllerNameAsGroup((HandlerMethod)handlerMethod) : tags.get(0);
        return tag;
    }

    private void initFrameworkEndpoint() {
        List newCompetences;
        LOGGER.info("\u6b63\u5728\u68c0\u6d4b\u548c\u8c03\u6574requestMapping\u548c\u6570\u636e\u5e93\u4e2dCompetence\u7684\u5bf9\u5e94\u5173\u7cfb======");
        Map pathMapping = this.frameworkEndpointHandler.getHandlerMethods();
        HashSet currentRequstUrls = Sets.newHashSet();
        Set requestMappings = pathMapping.keySet();
        HashMap urlCommentMapping = Maps.newHashMap();
        HashMap urlTags = new HashMap(128);
        for (RequestMappingInfo requestMappingInfo : requestMappings) {
            String comment;
            HashSet perCurrentRequstUrls = Sets.newHashSet();
            HandlerMethod handlerMethod = (HandlerMethod)pathMapping.get(requestMappingInfo);
            String tag = this.getTag(handlerMethod);
            Set requestMethods = requestMappingInfo.getMethodsCondition().getMethods();
            PatternsRequestCondition patternsRequestCondition = requestMappingInfo.getPatternsCondition();
            if (patternsRequestCondition == null) continue;
            Set patterns = patternsRequestCondition.getPatterns();
            String[] methodValues = requestMethods.stream().map(Object::toString).collect(Collectors.toList()).toArray(new String[0]);
            for (int index = 0; methodValues != null && index < methodValues.length; ++index) {
                String methodValue = methodValues[index];
                patterns.forEach(item -> {
                    perCurrentRequstUrls.add(item + "+" + methodValue);
                    urlTags.put(item, tag);
                });
            }
            if (handlerMethod == null) continue;
            ApiOperation apiOperation = (ApiOperation)handlerMethod.getMethodAnnotation(ApiOperation.class);
            if (apiOperation != null && StringUtils.isNotBlank((CharSequence)(comment = apiOperation.value()))) {
                perCurrentRequstUrls.forEach(item -> urlCommentMapping.put(item, comment));
            }
            currentRequstUrls.addAll(perCurrentRequstUrls);
        }
        List defaultCompetences = this.defaultCompetenceRepository.findAll();
        Set<Object> dbRequstUrls = null;
        dbRequstUrls = defaultCompetences != null ? defaultCompetences.stream().map(item -> item.getResource() + "+" + item.getMethods()).collect(Collectors.toSet()) : Sets.newHashSet();
        Sets.SetView difference = Sets.difference((Set)currentRequstUrls, (Set)dbRequstUrls);
        Pattern pattern = Pattern.compile("\\{[\\w]+\\}");
        if (difference != null && (newCompetences = difference.stream().map(item -> {
            String[] urlAndMethod = item.split("\\+");
            String url = urlAndMethod[0];
            String method = urlAndMethod[1];
            DefaultCompetenceVo competenceVo = new DefaultCompetenceVo();
            String comment = (String)urlCommentMapping.get(url);
            if (StringUtils.isNotBlank((CharSequence)comment)) {
                competenceVo.setComment(comment);
            } else {
                competenceVo.setComment(url);
            }
            competenceVo.setMethods(method);
            competenceVo.setResource(url);
            competenceVo.setSortIndex(100);
            competenceVo.setViewItem(0);
            competenceVo.setTag((String)urlTags.get(url));
            competenceVo.setType("default");
            competenceVo.setCode(UUID.randomUUID().toString());
            competenceVo.setCompetenceCode(competenceVo.getCode());
            if (pattern.matcher(url).find()) {
                competenceVo.setExtractUri(1);
            } else {
                competenceVo.setExtractUri(0);
            }
            return competenceVo;
        }).collect(Collectors.toList())) != null && !newCompetences.isEmpty()) {
            this.competenceVoService.create(newCompetences);
        }
    }
}

