/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.competence.tacit.local.register;

import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.competence.sdk.register.CompetenceRegister;
import com.bizunited.nebula.competence.sdk.vo.ButtonVo;
import com.bizunited.nebula.competence.sdk.vo.CompetenceVo;
import com.bizunited.nebula.competence.tacit.local.entity.DefaultCompetenceEntity;
import com.bizunited.nebula.competence.tacit.local.repository.DefaultCompetenceRepository;
import com.bizunited.nebula.competence.tacit.local.vo.DefaultButtonVo;
import com.bizunited.nebula.competence.tacit.local.vo.DefaultCompetenceVo;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;

@Component
public class DefaultCompetenceRegister
implements CompetenceRegister<DefaultCompetenceVo, DefaultButtonVo> {
    public static final String DEFAULT_TYPE = "default";
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private DefaultCompetenceRepository defaultCompetenceRepository;

    public String getType() {
        return DEFAULT_TYPE;
    }

    public String getComment() {
        return "\u9ed8\u8ba4";
    }

    public Class<DefaultCompetenceVo> getCompetenceClass() {
        return DefaultCompetenceVo.class;
    }

    public Class<DefaultButtonVo> getButtonClass() {
        return DefaultButtonVo.class;
    }

    public DefaultCompetenceVo cloneCompetence(CompetenceVo sourceCompetence) {
        DefaultCompetenceVo sourceDefaultCompetence = (DefaultCompetenceVo)sourceCompetence;
        DefaultCompetenceVo copyDefaultCompetence = (DefaultCompetenceVo)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)sourceDefaultCompetence, DefaultCompetenceVo.class, LinkedHashSet.class, ArrayList.class, new String[0]));
        List buttonVos = sourceDefaultCompetence.getButtons();
        ArrayList copyButtons = Lists.newArrayList();
        if (!CollectionUtils.isEmpty((Collection)buttonVos)) {
            for (ButtonVo buttonVo : buttonVos) {
                copyButtons.add(this.nebulaToolkitService.copyObjectByWhiteList((Object)buttonVo, buttonVo.getClass(), LinkedHashSet.class, ArrayList.class, new String[0]));
            }
            copyDefaultCompetence.setButtons(copyButtons);
        }
        return copyDefaultCompetence;
    }

    public DefaultButtonVo cloneButton(ButtonVo sourceButton) {
        DefaultButtonVo sourceDefaultButton = (DefaultButtonVo)sourceButton;
        DefaultButtonVo copyDefaultButton = (DefaultButtonVo)((Object)this.nebulaToolkitService.copyObjectByBlankList((Object)sourceDefaultButton, DefaultButtonVo.class, LinkedHashSet.class, ArrayList.class, new String[0]));
        return copyDefaultButton;
    }

    public Set<DefaultButtonVo> onRequestButtonVos(List<String> buttonCodes) {
        LinkedHashSet defaultButtonVos = Sets.newLinkedHashSet();
        for (String buttonCode : buttonCodes) {
            DefaultButtonVo defaultButtonVo = new DefaultButtonVo();
            defaultButtonVo.setCode(buttonCode);
            defaultButtonVo.setButtonCode(buttonCode);
            defaultButtonVos.add(defaultButtonVo);
        }
        return defaultButtonVos;
    }

    public Set<DefaultCompetenceVo> onRequestCompetenceVos(List<String> competenceCodes) {
        Set<DefaultCompetenceEntity> defaultCompetences = this.defaultCompetenceRepository.findByCompetenceCodes(competenceCodes);
        if (CollectionUtils.isEmpty(defaultCompetences)) {
            return Sets.newLinkedHashSet();
        }
        LinkedHashSet defaultCompetenceVos = Sets.newLinkedHashSet();
        for (DefaultCompetenceEntity defaultCompetence : defaultCompetences) {
            DefaultCompetenceVo defaultCompetenceVo = new DefaultCompetenceVo();
            defaultCompetenceVo.setCode(defaultCompetence.getCompetenceCode());
            defaultCompetenceVo.setCompetenceCode(defaultCompetence.getCompetenceCode());
            defaultCompetenceVo.setExtractUri(defaultCompetence.getExtractUri());
            defaultCompetenceVo.setMethods(defaultCompetence.getMethods());
            defaultCompetenceVo.setResource(defaultCompetence.getResource());
            defaultCompetenceVo.setTag(defaultCompetence.getTag());
            defaultCompetenceVo.setLinkType(defaultCompetence.getLinkType());
            defaultCompetenceVo.setLinkAuthType(defaultCompetence.getLinkAuthType());
            defaultCompetenceVo.setLinkUrl(defaultCompetence.getLinkUrl());
            defaultCompetenceVos.add(defaultCompetenceVo);
        }
        return defaultCompetenceVos;
    }

    public boolean matchedResources(CompetenceVo competence, String resource, String method, boolean like, String tenantCode) {
        DefaultCompetenceVo defaultCompetenceVo = (DefaultCompetenceVo)competence;
        String targetResource = defaultCompetenceVo.getResource();
        String targetMethods = defaultCompetenceVo.getMethods();
        Integer targetStatus = defaultCompetenceVo.getTstatus();
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{targetResource, targetMethods}) || targetStatus == null) {
            return false;
        }
        if (!StringUtils.isBlank((CharSequence)method) && StringUtils.indexOf((CharSequence)targetMethods, (CharSequence)method) == -1) {
            return false;
        }
        if (!like && StringUtils.equals((CharSequence)resource, (CharSequence)targetResource)) {
            return true;
        }
        return like && StringUtils.indexOf((CharSequence)resource, (CharSequence)targetResource) != -1;
    }

    public boolean matchedResources(CompetenceVo competence, RequestMappingInfo requestMappingInfo, String tenantCode, HttpServletRequest request) {
        DefaultCompetenceVo defaultCompetenceVo = (DefaultCompetenceVo)competence;
        String methods = defaultCompetenceVo.getMethods();
        String currentMethod = request.getMethod();
        String matchedFix = tenantCode + "|";
        if (methods.indexOf(currentMethod) == -1) {
            return false;
        }
        Set tenantAndRoleCodes = competence.getRoleCodes();
        if (CollectionUtils.isEmpty((Collection)tenantAndRoleCodes)) {
            return false;
        }
        for (String tenantAndRoleCode : tenantAndRoleCodes) {
            if (StringUtils.indexOf((CharSequence)tenantAndRoleCode, (CharSequence)matchedFix) == 0) continue;
            return true;
        }
        return false;
    }
}

