/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.europa.database.local.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bizunited.nebula.common.controller.BaseController;
import com.bizunited.nebula.common.controller.model.ResponseModel;
import com.bizunited.nebula.europa.database.sdk.strategy.ParameterValueBindingStrategy;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(value="ParameterValueBindingController", tags={"\u57fa\u4e8e\u6570\u636e\u5e93\u67e5\u8be2\u5b9e\u73b0\u7684\u6570\u636e\u89c6\u56fe\u53ef\u652f\u6301\u7684\u7ed1\u5b9a\u7b56\u7565\u4fe1\u606f"})
@RestController
@RequestMapping(value={"/v1/europa/parameterValueBindings"})
public class ParameterValueBindingController
extends BaseController {
    @Autowired
    private Set<ParameterValueBindingStrategy> parameterValueBindingStrategies;
    private static final Logger LOGGER = LoggerFactory.getLogger(ParameterValueBindingController.class);

    @ApiOperation(value="\u67e5\u8be2\u5f53\u524d\u6240\u6709\u652f\u6301\u7684\u6240\u6709\u53c2\u6570\u503c\u7ed1\u5b9a\u65b9\u5f0f\uff0c\u8fd9\u4e9b\u65b9\u5f0f\uff0c\u5c06\u6309\u7167bindTypeCnName\u7684\u503c\u8fdb\u884c\u6392\u5e8f")
    @RequestMapping(value={"/findAll"}, method={RequestMethod.GET})
    public ResponseModel findAll() {
        try {
            JSONArray resutls = new JSONArray();
            Set sortedParameterValueBindingStrategies = this.parameterValueBindingStrategies.stream().sorted((s, t) -> {
                String s_bindTypeCnName = s.getBindTypeCnName();
                String t_bindTypeCnName = t.getBindTypeCnName();
                return StringUtils.compare((String)s_bindTypeCnName, (String)t_bindTypeCnName);
            }).collect(Collectors.toSet());
            for (ParameterValueBindingStrategy parameterValueBindingStrategy : sortedParameterValueBindingStrategies) {
                String bindType = parameterValueBindingStrategy.getBindType();
                String bindTypeCnName = parameterValueBindingStrategy.getBindTypeCnName();
                Boolean outside = parameterValueBindingStrategy.getOutside();
                JSONObject item = new JSONObject();
                item.put("bindType", (Object)bindType);
                item.put("bindTypeCnName", (Object)bindTypeCnName);
                item.put("outside", (Object)outside);
                resutls.add((Object)item);
            }
            return this.buildHttpResult(resutls);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u6309\u7167\u503c\u7684\u6765\u6e90\u548c\u9002\u7528\u7684java\u7c7b\u578b\u8fdb\u884c\u67e5\u8be2\uff0c\u5e76\u6309\u7167bindTypeCnName\u7684\u503c\u8fdb\u884c\u6392\u5e8f")
    @RequestMapping(value={"/findByOutsideAndJavaClass"}, method={RequestMethod.GET})
    public ResponseModel findByOutside(@RequestParam(value="outside") Boolean outside, @RequestParam(value="javaClass") String javaClass) {
        if (outside == null || StringUtils.isBlank((CharSequence)javaClass)) {
            return this.buildHttpResult();
        }
        try {
            Class<?> currentClass = Class.forName(javaClass);
            JSONArray resutls = new JSONArray();
            Set sortedParameterValueBindingStrategies = this.parameterValueBindingStrategies.stream().filter(item -> item.getOutside().booleanValue() == outside.booleanValue()).filter(item -> {
                Class[] matchedJavaClasses = item.matchedJavaClasses();
                if (matchedJavaClasses == null || matchedJavaClasses.length == 0) {
                    return false;
                }
                boolean isMatched = false;
                for (Class matchedJavaClass : matchedJavaClasses) {
                    if (!matchedJavaClass.isAssignableFrom(currentClass)) continue;
                    isMatched = true;
                    break;
                }
                return isMatched;
            }).sorted((s, t) -> {
                String s_bindTypeCnName = s.getBindTypeCnName();
                String t_bindTypeCnName = t.getBindTypeCnName();
                return StringUtils.compare((String)s_bindTypeCnName, (String)t_bindTypeCnName);
            }).collect(Collectors.toSet());
            for (ParameterValueBindingStrategy parameterValueBindingStrategy : sortedParameterValueBindingStrategies) {
                String bindType = parameterValueBindingStrategy.getBindType();
                String bindTypeCnName = parameterValueBindingStrategy.getBindTypeCnName();
                Boolean itemOutside = parameterValueBindingStrategy.getOutside();
                JSONObject item2 = new JSONObject();
                item2.put("bindType", (Object)bindType);
                item2.put("bindTypeCnName", (Object)bindTypeCnName);
                item2.put("outside", (Object)itemOutside);
                resutls.add((Object)item2);
            }
            return this.buildHttpResult(resutls);
        }
        catch (ClassNotFoundException | RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }
}

