/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.europa.database.local.resolver;

import com.alibaba.druid.pool.DruidDataSource;
import com.alibaba.druid.sql.SQLUtils;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.expr.SQLAllColumnExpr;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.expr.SQLPropertyExpr;
import com.alibaba.druid.sql.ast.statement.SQLExprTableSource;
import com.alibaba.druid.sql.ast.statement.SQLJoinTableSource;
import com.alibaba.druid.sql.ast.statement.SQLSelect;
import com.alibaba.druid.sql.ast.statement.SQLSelectItem;
import com.alibaba.druid.sql.ast.statement.SQLSelectQueryBlock;
import com.alibaba.druid.sql.ast.statement.SQLSelectStatement;
import com.alibaba.druid.sql.ast.statement.SQLSubqueryTableSource;
import com.alibaba.druid.sql.ast.statement.SQLTableSource;
import com.bizunited.nebula.common.enums.DatabaseType;
import com.bizunited.nebula.europa.database.sdk.context.matedata.DatabaseMetaData;
import com.bizunited.nebula.europa.database.sdk.context.matedata.DatabaseMetaDataField;
import com.bizunited.nebula.europa.database.sdk.service.MetaDataResolver;
import com.bizunited.nebula.europa.database.sdk.utils.SQLAnalyzeUtils;
import com.bizunited.nebula.europa.sdk.context.matedata.MetaData;
import com.bizunited.nebula.europa.sdk.context.matedata.MetaDataField;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLSyntaxErrorException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component(value="PostgreSQLDruidResolver")
public class PostgreSQLDruidResolver
implements MetaDataResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(PostgreSQLDruidResolver.class);
    private static final String[] DRIVER_CLASS_NAMES = new String[]{"org.postgresql.Driver"};
    private static final String REBUILD_FIELD_ALIS_SEPARATOR = "__s__";

    public boolean validate(DataSource dataSource) {
        if (!(dataSource instanceof DruidDataSource)) {
            return false;
        }
        String driverClassName = ((DruidDataSource)dataSource).getDriverClassName();
        return StringUtils.equalsAny((CharSequence)driverClassName, (CharSequence[])DRIVER_CLASS_NAMES);
    }

    public MetaData resolver(Connection currentConnection, String sql) throws SQLException {
        LOGGER.info("\u6267\u884cPSQL-------------");
        SqlFromTableInfo factFieldCollectTableInfo = this.buildFactFieldTableInfo(currentConnection, sql);
        String rebuildSql = this.rebuildSql(currentConnection, sql, factFieldCollectTableInfo);
        String callableSql = SQLAnalyzeUtils.convertToParameterSQL((String)rebuildSql);
        Map sqlParametersIndexMapping = SQLAnalyzeUtils.analyzeSQLParametersMapping((String)rebuildSql);
        PreparedStatement ps = currentConnection.prepareStatement(callableSql);
        ResultSetMetaData resultSetMetaData = ps.getMetaData();
        int columnCount = resultSetMetaData.getColumnCount();
        DatabaseMetaData databaseMetaData = new DatabaseMetaData("database");
        Map<String, SqlFromTableFieldInfo> allFieldNameMap = factFieldCollectTableInfo.getAllFieldNameMap();
        for (int index = 1; index <= columnCount; ++index) {
            String fieldName;
            String alias;
            String fieldOriginalName;
            String fieldCnName;
            String columnLabel = resultSetMetaData.getColumnLabel(index);
            String[] fieldSplit = columnLabel.split(REBUILD_FIELD_ALIS_SEPARATOR);
            if (fieldSplit.length == 3) {
                fieldCnName = fieldSplit[2];
                fieldOriginalName = fieldSplit[1];
                alias = fieldSplit[0];
                fieldName = fieldCnName;
            } else {
                fieldCnName = columnLabel;
                fieldName = resultSetMetaData.getColumnName(index);
                Validate.notBlank((CharSequence)fieldName, (String)"\u672a\u83b7\u53d6\u5230\u5143\u6570\u636e\u5217\u4e2d\u7684\u5b57\u6bb5\u540d\u79f0\u4fe1\u606f", (Object[])new Object[0]);
                alias = resultSetMetaData.getTableName(index);
                if (StringUtils.isBlank((CharSequence)alias)) {
                    alias = "";
                }
                fieldOriginalName = fieldName;
            }
            String tableName = resultSetMetaData.getTableName(index);
            String className = resultSetMetaData.getColumnClassName(index);
            SqlFromTableFieldInfo tableFieldInfo = allFieldNameMap.get(String.format("%s_alis_%s", alias, fieldOriginalName));
            String fieldComment = Objects.nonNull(tableFieldInfo) ? tableFieldInfo.fieldComment : null;
            Validate.notBlank((CharSequence)className, (String)"\u672a\u83b7\u53d6\u5230\u5143\u6570\u636e\u5217\u4e2d\u7684\u5b57\u6bb5\u7c7b\u578b\u4fe1\u606f", (Object[])new Object[0]);
            try {
                Class<?> currentClass = Class.forName(className);
                Validate.isTrue((!currentClass.isArray() ? 1 : 0) != 0, (String)"\u5143\u6570\u636e\u4e2d\u7684\u5b57\u6bb5\u4e0d\u53ef\u80fd\u4e3a\u6570\u7ec4", (Object[])new Object[0]);
                Validate.isTrue((!Iterable.class.isAssignableFrom(currentClass) ? 1 : 0) != 0, (String)"\u5143\u6570\u636e\u4e2d\u7684\u5b57\u6bb5\u4e0d\u53ef\u80fd\u4e3a\u96c6\u5408", (Object[])new Object[0]);
                Validate.isTrue((!Map.class.isAssignableFrom(currentClass) ? 1 : 0) != 0, (String)"\u5143\u6570\u636e\u4e2d\u7684\u5b57\u6bb5\u4e0d\u53ef\u80fd\u4e3a\u6620\u5c04K-V\u7ed3\u6784", (Object[])new Object[0]);
            }
            catch (ClassNotFoundException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
                throw new IllegalArgumentException(e.getMessage(), e);
            }
            DatabaseMetaDataField databaseMetaDataField = new DatabaseMetaDataField();
            databaseMetaDataField.setAlias(alias);
            databaseMetaDataField.setTableName(tableName);
            databaseMetaDataField.setFieldName(fieldName);
            databaseMetaDataField.setFieldOriginalName(fieldOriginalName);
            databaseMetaDataField.setFieldCnName(fieldCnName);
            databaseMetaDataField.setJavaClassName(className);
            databaseMetaDataField.setFieldComment(fieldComment);
            databaseMetaData.addMetaDataField((MetaDataField)databaseMetaDataField);
        }
        ParameterMetaData parameterMetaData = ps.getParameterMetaData();
        int parameterCount = parameterMetaData.getParameterCount();
        HashMap<String, String> addedParameters = new HashMap<String, String>();
        for (int idx = 1; idx <= parameterCount; ++idx) {
            String parameterClassName = parameterMetaData.getParameterClassName(idx);
            String parameterName = (String)sqlParametersIndexMapping.get(idx);
            String addedClassName = (String)addedParameters.get(parameterName);
            if (addedClassName == null) {
                databaseMetaData.addParameter(idx, parameterName, parameterClassName);
            } else {
                Validate.isTrue((boolean)StringUtils.equals((CharSequence)addedClassName, (CharSequence)parameterClassName), (String)"\u53c2\u6570 %s \u91cd\u590d\u51fa\u73b0\u4e14\u7c7b\u578b\u4e0d\u4e00\u81f4\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[]{parameterName});
            }
            addedParameters.put(parameterName, parameterClassName);
        }
        List primaryKeyFields = factFieldCollectTableInfo.allFieldList.stream().collect(Collectors.toMap(fi -> String.format("%s-%s", ((SqlFromTableFieldInfo)fi).tableAlis, ((SqlFromTableFieldInfo)fi).fieldName), t -> t, (a, b) -> a)).values().stream().filter(fi -> ((SqlFromTableFieldInfo)fi).primaryKey).map(fi -> {
            DatabaseMetaDataField f = new DatabaseMetaDataField();
            f.setAlias(((SqlFromTableFieldInfo)fi).tableAlis);
            f.setTableName(((SqlFromTableFieldInfo)fi).tableAlis);
            f.setFieldName(((SqlFromTableFieldInfo)fi).fieldName);
            f.setFieldOriginalName(((SqlFromTableFieldInfo)fi).fieldName);
            f.setFieldCnName(((SqlFromTableFieldInfo)fi).fieldName);
            return f;
        }).collect(Collectors.toList());
        databaseMetaData.setPrimaryKeyFields(primaryKeyFields);
        return databaseMetaData;
    }

    private String rebuildSql(Connection connection, String sql, SqlFromTableInfo factFieldCollectTableInfo) {
        String rebuildSql = sql;
        try {
            List list = SQLUtils.parseStatements((String)sql, (String)DatabaseType.POSTGRESQL.getDesc());
            if (list.size() > 1) {
                throw new SQLSyntaxErrorException("MultiQueries is not supported,use single query instead ");
            }
            SQLSelectStatement sqlStatement = (SQLSelectStatement)list.get(0);
            SQLSelect sqlSelect = sqlStatement.getSelect();
            SQLSelectQueryBlock sqlSelectQuery = (SQLSelectQueryBlock)sqlSelect.getQuery();
            HashSet tableList = Sets.newHashSet();
            this.analysisTable(sqlSelectQuery.getFrom(), tableList);
            Map<String, SqlFromTableInfo> tableInfoMap = tableList.stream().collect(Collectors.toMap(o -> ((SqlFromTableInfo)o).tableAlis, t -> t));
            List selectList = sqlSelectQuery.getSelectList();
            ArrayList newSelectList = Lists.newArrayList();
            for (SQLSelectItem sqlSelectItem : selectList) {
                SQLExpr expr = sqlSelectItem.getExpr();
                if (expr instanceof SQLPropertyExpr) {
                    SQLPropertyExpr sqlPropertyExpr = (SQLPropertyExpr)expr;
                    SqlFromTableInfo tableInfo2 = tableInfoMap.get(sqlPropertyExpr.getOwnernName());
                    Validate.notNull((Object)tableInfo2, (String)"\u8868\u522b\u540d%s\u5bf9\u5e94\u6570\u636e\u8868\u4e0d\u5b58\u5728", (Object[])new Object[]{sqlSelectItem.getAlias()});
                    if ("*".equals(sqlPropertyExpr.getName())) {
                        List<String> fieldNames = this.getFieldNames(connection, tableInfo2, factFieldCollectTableInfo);
                        int i = selectList.indexOf(sqlSelectItem);
                        newSelectList.addAll(i, fieldNames.stream().map(fieldName -> {
                            SQLPropertyExpr propertyExpr = new SQLPropertyExpr(sqlPropertyExpr.getOwnernName(), fieldName);
                            return new SQLSelectItem((SQLExpr)propertyExpr, String.join((CharSequence)REBUILD_FIELD_ALIS_SEPARATOR, propertyExpr.getOwnernName(), fieldName, fieldName));
                        }).collect(Collectors.toList()));
                        continue;
                    }
                    sqlSelectItem.setAlias(String.join((CharSequence)REBUILD_FIELD_ALIS_SEPARATOR, sqlPropertyExpr.getOwnernName(), sqlPropertyExpr.getName(), (CharSequence)ObjectUtils.defaultIfNull((Object)sqlSelectItem.getAlias(), (Object)sqlPropertyExpr.getName())));
                    newSelectList.add(sqlSelectItem);
                    continue;
                }
                if (expr instanceof SQLAllColumnExpr) {
                    tableInfoMap.forEach((ownerName, tableInfo) -> {
                        List<String> fieldNames = this.getFieldNames(connection, (SqlFromTableInfo)tableInfo, factFieldCollectTableInfo);
                        newSelectList.addAll(fieldNames.stream().map(fieldName -> {
                            SQLPropertyExpr propertyExpr = new SQLPropertyExpr(ownerName, fieldName);
                            return new SQLSelectItem((SQLExpr)propertyExpr, String.join((CharSequence)REBUILD_FIELD_ALIS_SEPARATOR, propertyExpr.getOwnernName(), fieldName, fieldName));
                        }).collect(Collectors.toList()));
                    });
                    continue;
                }
                newSelectList.add(sqlSelectItem);
            }
            sqlSelectQuery.getSelectList().clear();
            sqlSelectQuery.getSelectList().addAll(newSelectList);
            rebuildSql = sqlSelect.toString();
        }
        catch (Exception e) {
            LOGGER.error("\u91c7\u7528druid\u8fdb\u884c\u5143\u6570\u636e\u89e3\u6790\u91cd\u6784sql\u51fa\u9519,\u5c06\u91c7\u7528\u539f\u59cbsql\u8fdb\u884c\u5143\u6570\u636e\u89e3\u6790", (Throwable)e);
        }
        return rebuildSql;
    }

    private List<String> getFieldNames(Connection connection, SqlFromTableInfo tableInfo, SqlFromTableInfo factFieldCollectTableInfo) {
        List<String> fieldNames = new ArrayList<String>();
        if (Boolean.TRUE.equals(tableInfo.subQueryFlag)) {
            List<Field> fieldList = this.findFieldBySql(connection, tableInfo.tableName);
            if (!CollectionUtils.isEmpty(fieldList)) {
                fieldNames = fieldList.stream().map(Field::getName).collect(Collectors.toList());
            }
        } else {
            List tableFieldInfoList = factFieldCollectTableInfo.getTableFieldNameMap().get(tableInfo.tableAlis);
            tableFieldInfoList = (List)ObjectUtils.defaultIfNull(tableFieldInfoList, new ArrayList());
            fieldNames = tableFieldInfoList.stream().map(field -> ((SqlFromTableFieldInfo)field).fieldName).collect(Collectors.toList());
        }
        return fieldNames;
    }

    private List<SqlFromTableFieldInfo> findFieldByTableName(Connection connection, String tableName, String tableAlis) {
        ArrayList<SqlFromTableFieldInfo> fieldList = new ArrayList<SqlFromTableFieldInfo>();
        try {
            String columnSql = "SELECT column_name, col_description(format('%s.%s', table_schema, table_name)::regclass::oid, ordinal_position) AS comment FROM information_schema.columns WHERE table_name = ? AND table_schema = current_schema()";
            PreparedStatement ps = connection.prepareStatement(columnSql);
            ps.setString(1, tableName);
            ResultSet rs = ps.executeQuery();
            Set<String> primaryKeys = this.getPrimaryKeys(connection, tableName);
            while (rs.next()) {
                String fieldName = rs.getString("column_name");
                String comment = rs.getString("comment");
                boolean isPrimary = primaryKeys.contains(fieldName);
                fieldList.add(new SqlFromTableFieldInfo(tableAlis, fieldName, comment, isPrimary));
            }
        }
        catch (SQLException e) {
            LOGGER.warn("PostgreSQL: \u67e5\u8be2\u5b57\u6bb5\u4fe1\u606f\u5931\u8d25\uff0c\u8868\uff1a{}", (Object)tableName, (Object)e);
        }
        return fieldList;
    }

    private Set<String> getPrimaryKeys(Connection connection, String tableName) throws SQLException {
        HashSet<String> primaryKeys = new HashSet<String>();
        String pkSql = "SELECT kcu.column_name FROM information_schema.table_constraints tc JOIN information_schema.key_column_usage kcu   ON tc.constraint_name = kcu.constraint_name WHERE tc.table_name = ? AND tc.constraint_type = 'PRIMARY KEY'";
        try (PreparedStatement ps = connection.prepareStatement(pkSql);){
            ps.setString(1, tableName);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    primaryKeys.add(rs.getString("column_name"));
                }
            }
        }
        return primaryKeys;
    }

    private List<Field> findFieldBySql(Connection connection, String sql) {
        return Collections.emptyList();
    }

    public SqlFromTableInfo analysisFactFieldInfo(Connection connection, String sql, String alis) {
        List list = SQLUtils.parseStatements((String)sql, (String)DatabaseType.MYSQL.getDesc());
        if (list.size() > 1) {
            throw new RuntimeException("MultiQueries is not supported,use single query instead");
        }
        SQLSelectStatement sqlStatement = (SQLSelectStatement)list.get(0);
        SQLSelect sqlSelect = sqlStatement.getSelect();
        SqlFromTableInfo resultTableInfo = new SqlFromTableInfo(alis, "selectCollect", Boolean.FALSE);
        SQLSelectQueryBlock sqlSelectQuery = (SQLSelectQueryBlock)sqlSelect.getQuery();
        HashSet analysisTableSet = Sets.newHashSet();
        SQLTableSource sqlTableSource = sqlSelectQuery.getFrom();
        this.analysisTable(sqlTableSource, analysisTableSet);
        if (CollectionUtils.isEmpty((Collection)analysisTableSet)) {
            return resultTableInfo;
        }
        HashSet resultTableSet = Sets.newHashSet();
        analysisTableSet.forEach(sqlFromTableInfo -> {
            if (Boolean.FALSE.equals(((SqlFromTableInfo)sqlFromTableInfo).subQueryFlag)) {
                ((SqlFromTableInfo)sqlFromTableInfo).allFieldList = this.findFieldByTableName(connection, ((SqlFromTableInfo)sqlFromTableInfo).tableName, ((SqlFromTableInfo)sqlFromTableInfo).tableAlis);
                resultTableSet.add(sqlFromTableInfo);
            } else {
                resultTableSet.add(this.analysisFactFieldInfo(connection, ((SqlFromTableInfo)sqlFromTableInfo).tableName, ((SqlFromTableInfo)sqlFromTableInfo).tableAlis));
            }
        });
        Map<String, SqlFromTableInfo> tableInfoMap = resultTableSet.stream().collect(Collectors.toMap(o -> ((SqlFromTableInfo)o).tableAlis, t -> t));
        List selectList = sqlSelectQuery.getSelectList();
        for (SQLSelectItem sqlSelectItem : selectList) {
            SQLExpr expr = sqlSelectItem.getExpr();
            if (expr instanceof SQLPropertyExpr) {
                SQLPropertyExpr sqlPropertyExpr = (SQLPropertyExpr)expr;
                SqlFromTableInfo tableInfo2 = tableInfoMap.get(sqlPropertyExpr.getOwnernName());
                Validate.notNull((Object)tableInfo2, (String)"\u8868\u522b\u540d%s\u5bf9\u5e94\u6570\u636e\u8868\u4e0d\u5b58\u5728", (Object[])new Object[]{sqlSelectItem.getAlias()});
                Validate.notNull((Object)tableInfo2, (String)"\u8868\u522b\u540d%s\u5bf9\u5e94\u6570\u636e\u8868\u5b57\u6bb5\u89e3\u6790\u5931\u8d25", (Object[])new Object[]{sqlSelectItem.getAlias()});
                if ("*".equals(sqlPropertyExpr.getName())) {
                    resultTableInfo.allFieldList.addAll(tableInfo2.allFieldList);
                    continue;
                }
                Map<String, SqlFromTableFieldInfo> allFieldNameMap = tableInfo2.getAllFieldNameMap();
                SqlFromTableFieldInfo tableFieldInfo = allFieldNameMap.get(String.format("%s_alis_%s", sqlPropertyExpr.getOwnernName(), sqlPropertyExpr.getName()));
                if (!Objects.nonNull(tableFieldInfo)) continue;
                resultTableInfo.allFieldList.add(tableFieldInfo);
                continue;
            }
            if (expr instanceof SQLIdentifierExpr) {
                SQLIdentifierExpr sqlIdentifierExpr = (SQLIdentifierExpr)expr;
                tableInfoMap.forEach((ownerName, tableInfo) -> {
                    Map<String, SqlFromTableFieldInfo> allFieldNameMap = tableInfo.getAllFieldNameMap();
                    SqlFromTableFieldInfo tableFieldInfo = allFieldNameMap.get(String.format("%s_alis_%s", ownerName, sqlIdentifierExpr.getName()));
                    if (Objects.nonNull(tableFieldInfo)) {
                        resultTableInfo.allFieldList.add(tableFieldInfo);
                    }
                });
                continue;
            }
            if (!(expr instanceof SQLAllColumnExpr)) continue;
            tableInfoMap.forEach((ownerName, tableInfo) -> resultTableInfo.allFieldList.addAll(((SqlFromTableInfo)tableInfo).allFieldList));
        }
        return resultTableInfo;
    }

    private SqlFromTableInfo buildFactFieldTableInfo(Connection connection, String sql) {
        SqlFromTableInfo resultTableInfo;
        try {
            resultTableInfo = this.analysisFactFieldInfo(connection, sql, "selectCollect");
        }
        catch (Exception e) {
            LOGGER.error("\u91c7\u7528druid\u8fdb\u884c\u5143\u6570\u636e\u89e3\u6790\u91cd\u6784sql\u51fa\u9519,\u5c06\u91c7\u7528\u539f\u59cbsql\u8fdb\u884c\u5143\u6570\u636e\u89e3\u6790", (Throwable)e);
            resultTableInfo = new SqlFromTableInfo("selectCollect", "selectCollect", Boolean.FALSE);
        }
        return resultTableInfo;
    }

    public void analysisTable(SQLTableSource fromSQLTableSource, Set<SqlFromTableInfo> tableList) {
        if (fromSQLTableSource instanceof SQLExprTableSource) {
            SQLExprTableSource sqlExprTableSource = (SQLExprTableSource)fromSQLTableSource;
            SQLExpr sqlExpr = sqlExprTableSource.getExpr();
            if (sqlExpr instanceof SQLIdentifierExpr) {
                SQLIdentifierExpr sqlIdentifierExpr = (SQLIdentifierExpr)sqlExpr;
                String tableName = sqlIdentifierExpr.getName();
                String alias = sqlExprTableSource.getAlias();
                alias = StringUtils.isNotBlank((CharSequence)alias) ? alias : tableName;
                SqlFromTableInfo databaseTableNode = new SqlFromTableInfo(alias, tableName, Boolean.FALSE);
                tableList.add(databaseTableNode);
            }
        } else if (fromSQLTableSource instanceof SQLSubqueryTableSource) {
            SQLSubqueryTableSource subqueryTableSource = (SQLSubqueryTableSource)fromSQLTableSource;
            String alias = subqueryTableSource.getAlias();
            SqlFromTableInfo tableInfo = new SqlFromTableInfo(alias, subqueryTableSource.toString(), Boolean.TRUE);
            tableList.add(tableInfo);
        } else if (fromSQLTableSource instanceof SQLJoinTableSource) {
            SQLJoinTableSource sqlJoinTableSource = (SQLJoinTableSource)fromSQLTableSource;
            SQLTableSource leftSQLTableSource = sqlJoinTableSource.getLeft();
            this.analysisTable(leftSQLTableSource, tableList);
            SQLTableSource rightSQLTableSource = sqlJoinTableSource.getRight();
            this.analysisTable(rightSQLTableSource, tableList);
        }
    }

    private static class SqlFromTableFieldInfo {
        private String tableAlis;
        private String fieldName;
        private String fieldComment;
        private Boolean primaryKey;

        public SqlFromTableFieldInfo(String tableAlis, String fieldName, String fieldComment, Boolean primaryKey) {
            this.tableAlis = tableAlis;
            this.fieldName = fieldName;
            this.fieldComment = fieldComment;
            this.primaryKey = primaryKey;
        }
    }

    private static class SqlFromTableInfo {
        private String tableAlis;
        private String tableName;
        private Boolean subQueryFlag;
        private List<SqlFromTableFieldInfo> allFieldList;

        public SqlFromTableInfo(String tableAlis, String tableName, Boolean subQueryFlag) {
            this.tableAlis = tableAlis;
            this.tableName = tableName;
            this.subQueryFlag = subQueryFlag;
            this.allFieldList = Lists.newArrayList();
        }

        public Map<String, SqlFromTableFieldInfo> getAllFieldNameMap() {
            HashMap fieldMap = Maps.newHashMap();
            if (CollectionUtils.isEmpty(this.allFieldList)) {
                return fieldMap;
            }
            return this.allFieldList.stream().collect(Collectors.toMap(fieldInfo -> String.format("%s_alis_%s", ((SqlFromTableFieldInfo)fieldInfo).tableAlis, ((SqlFromTableFieldInfo)fieldInfo).fieldName), t -> t, (a, b) -> a));
        }

        public Map<String, List<SqlFromTableFieldInfo>> getTableFieldNameMap() {
            HashMap fieldMap = Maps.newHashMap();
            if (CollectionUtils.isEmpty(this.allFieldList)) {
                return fieldMap;
            }
            return this.allFieldList.stream().collect(Collectors.groupingBy(o -> ((SqlFromTableFieldInfo)o).tableAlis));
        }
    }
}

