/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.europa.database.local.service;

import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.europa.database.sdk.service.DatabaseViewVoService;
import com.bizunited.nebula.europa.database.sdk.vo.DatabaseViewVo;
import com.bizunited.nebula.europa.sdk.service.strategy.EuropaInfoMaintainStrategy;
import com.bizunited.nebula.europa.sdk.vo.AbstractView;
import com.bizunited.nebula.europa.sdk.vo.EuropaInfoVo;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="databaseEuropaInfoMaintainStrategy")
public class DatabaseEuropaInfoMaintainStrategy
implements EuropaInfoMaintainStrategy {
    @Autowired
    private DatabaseViewVoService databaseViewVoService;

    public boolean validate(EuropaInfoVo europaInfoVo) {
        String sourceType = europaInfoVo.getSourceType();
        return !StringUtils.isBlank((CharSequence)sourceType) && StringUtils.equals((CharSequence)sourceType, (CharSequence)"database");
    }

    @Transactional
    public void create(EuropaInfoVo europaInfo) {
        AbstractView abstractView = europaInfo.getView();
        Validate.notNull((Object)abstractView, (String)"\u9519\u8bef\u7684\u6570\u636e\u89c6\u56fe\u6269\u5c55\u4fe1\u606f!!", (Object[])new Object[0]);
        if (!(abstractView instanceof DatabaseViewVo)) {
            return;
        }
        DatabaseViewVo databaseViewVo = (DatabaseViewVo)abstractView;
        databaseViewVo.setEuropaCode(europaInfo.getCode());
        this.databaseViewVoService.create(databaseViewVo);
    }

    @Transactional
    public void update(EuropaInfoVo europaInfo) {
        AbstractView abstractView = europaInfo.getView();
        Validate.notNull((Object)abstractView, (String)"\u9519\u8bef\u7684\u6570\u636e\u89c6\u56fe\u6269\u5c55\u4fe1\u606f!!", (Object[])new Object[0]);
        if (!(abstractView instanceof DatabaseViewVo)) {
            return;
        }
        DatabaseViewVo databaseViewVo = (DatabaseViewVo)abstractView;
        databaseViewVo.setTenantCode(europaInfo.getTenantCode());
        databaseViewVo.setName(europaInfo.getName());
        databaseViewVo.setEuropaCode(europaInfo.getCode());
        this.databaseViewVoService.update(databaseViewVo);
    }

    @Transactional
    public void delete(EuropaInfoVo europaInfoVo) {
        String tenantCode = europaInfoVo.getTenantCode();
        String europaCode = europaInfoVo.getCode();
        this.databaseViewVoService.delete(europaCode, tenantCode);
    }

    public AbstractView request(String sourceType, String europaInfoCode) {
        if (!StringUtils.equals((CharSequence)"database", (CharSequence)sourceType)) {
            return null;
        }
        String tenantCode = TenantUtils.getTenantCode();
        DatabaseViewVo databaseViewVo = this.databaseViewVoService.findByEuropaCodeAndTenantCode(europaInfoCode, tenantCode);
        return databaseViewVo;
    }
}

