/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.europa.database.local.service.internal;

import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.europa.database.local.entity.DataSourceEntity;
import com.bizunited.nebula.europa.database.local.entity.DatabaseViewEntity;
import com.bizunited.nebula.europa.database.local.entity.DatabaseViewExternalFieldEntity;
import com.bizunited.nebula.europa.database.local.entity.DatabaseViewMateDataConditionEntity;
import com.bizunited.nebula.europa.database.local.entity.DatabaseViewOrderEntity;
import com.bizunited.nebula.europa.database.local.entity.DatabaseViewParameterConditionEntity;
import com.bizunited.nebula.europa.database.local.repository.DataSourceRepository;
import com.bizunited.nebula.europa.database.local.repository.DatabaseViewExternalFieldRepository;
import com.bizunited.nebula.europa.database.local.repository.DatabaseViewMateDataConditionRepository;
import com.bizunited.nebula.europa.database.local.repository.DatabaseViewOrderRepository;
import com.bizunited.nebula.europa.database.local.repository.DatabaseViewParameterConditionRepository;
import com.bizunited.nebula.europa.database.local.repository.DatabaseViewRepository;
import com.bizunited.nebula.europa.database.sdk.service.DatabaseViewVoService;
import com.bizunited.nebula.europa.database.sdk.strategy.ExternalQueryInterceptor;
import com.bizunited.nebula.europa.database.sdk.strategy.ParameterOperatorBindingStrategy;
import com.bizunited.nebula.europa.database.sdk.strategy.ParameterValueBindingStrategy;
import com.bizunited.nebula.europa.database.sdk.vo.DatabaseViewExternalFieldVo;
import com.bizunited.nebula.europa.database.sdk.vo.DatabaseViewMateDataConditionVo;
import com.bizunited.nebula.europa.database.sdk.vo.DatabaseViewOrderVo;
import com.bizunited.nebula.europa.database.sdk.vo.DatabaseViewParameterConditionVo;
import com.bizunited.nebula.europa.database.sdk.vo.DatabaseViewVo;
import com.bizunited.nebula.europa.sdk.strategy.ViewInfoValidateStrategy;
import com.bizunited.nebula.europa.sdk.vo.AbstractView;
import com.bizunited.nebula.security.sdk.config.SimpleSecurityProperties;
import com.bizunited.nebula.security.sdk.login.UserIdentity;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="databaseViewVoService")
public class DatabaseViewVoServiceImpl
implements DatabaseViewVoService {
    @Autowired
    private DatabaseViewRepository databaseViewRepository;
    @Autowired
    private DataSourceRepository dataSourceRepository;
    @Autowired
    private DatabaseViewParameterConditionRepository databaseViewParameterConditionRepository;
    @Autowired
    private DatabaseViewMateDataConditionRepository databaseViewMateDataConditionRepository;
    @Autowired
    private DatabaseViewOrderRepository databaseViewOrderRepository;
    @Autowired
    private DatabaseViewExternalFieldRepository databaseViewExternalFieldRepository;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private List<ViewInfoValidateStrategy> viewInfoValidateStrateies;
    @Autowired(required=false)
    @Lazy
    private List<ExternalQueryInterceptor> externalQueryInterceptors;
    @Autowired
    @Lazy
    private List<ParameterValueBindingStrategy> parameterValueBindingStrateies;
    @Autowired
    @Lazy
    private List<ParameterOperatorBindingStrategy> parameterOperatorBindingStrateies;
    @Autowired
    private SimpleSecurityProperties simpleSecurityProperties;

    @Transactional
    public DatabaseViewVo create(DatabaseViewVo databaseView) {
        Validate.notNull((Object)databaseView, (String)"\u521b\u5efa\u65f6\uff0c\u9519\u8bef\u7684\u6570\u636e\u5e93\u67e5\u8be2\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        String tenantCode = TenantUtils.getTenantCode();
        databaseView.setTenantCode(tenantCode);
        databaseView.setId(null);
        SecurityContext securityContext = SecurityContextHolder.getContext();
        Authentication authentication = securityContext.getAuthentication();
        Object authDetailsObject = authentication.getDetails();
        String account = null;
        if (authDetailsObject instanceof UserIdentity) {
            UserIdentity userIdentity = (UserIdentity)authDetailsObject;
            account = userIdentity.getAccount();
        } else {
            account = this.simpleSecurityProperties.getIndependencyUser();
        }
        Date date = new Date();
        databaseView.setCreateAccount(account);
        databaseView.setCreateTime(date);
        databaseView.setModifyAccount(account);
        databaseView.setModifyTime(date);
        boolean validate = false;
        if (!CollectionUtils.isEmpty(this.viewInfoValidateStrateies)) {
            ViewInfoValidateStrategy matchedViewInfoValidateStrategy = null;
            for (ViewInfoValidateStrategy viewInfoValidateStrategy : this.viewInfoValidateStrateies) {
                if (!viewInfoValidateStrategy.support(true, (AbstractView)databaseView)) continue;
                matchedViewInfoValidateStrategy = viewInfoValidateStrategy;
                break;
            }
            if (matchedViewInfoValidateStrategy != null) {
                matchedViewInfoValidateStrategy.validate(true, (AbstractView)databaseView);
                validate = true;
            }
        }
        Validate.isTrue((boolean)validate, (String)"\u521b\u5efa\u65f6\uff0c\u672a\u53d1\u73b0\u6570\u636e\u89c6\u56fe\u5339\u914d\u7684\u9a8c\u8bc1\u903b\u8f91\uff0c\u6700\u53ef\u80fd\u7684\u60c5\u51b5\u662f\u6570\u636e\u89c6\u56fe\u6e90\u7c7b\u578b\u6ca1\u6709\u586b\u5199!!", (Object[])new Object[0]);
        String databaseCode = databaseView.getDatasouceCode();
        DataSourceEntity databaseSource = null;
        if (StringUtils.isNotBlank((CharSequence)databaseCode)) {
            databaseSource = this.dataSourceRepository.findByCodeAndTenantCode(databaseCode, tenantCode);
            Validate.notNull((Object)((Object)databaseSource), (String)"\u521b\u5efa\u65f6\uff0c\u672a\u627e\u5230\u6570\u636e\u5e93\u8bbe\u7f6e\u4fe1\u606f!!", (Object[])new Object[0]);
        }
        DatabaseViewEntity databaseViewEntity = (DatabaseViewEntity)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)databaseView, DatabaseViewEntity.class, LinkedHashSet.class, ArrayList.class, new String[0]));
        databaseViewEntity.setDataSource(databaseSource);
        this.databaseViewRepository.save((Object)databaseViewEntity);
        databaseView.setId(databaseViewEntity.getId());
        this.createQueryCondition(databaseViewEntity, databaseView);
        this.createOrder(databaseViewEntity, databaseView);
        this.createExternalQueryFields(databaseViewEntity, databaseView);
        return databaseView;
    }

    private void createQueryCondition(DatabaseViewEntity databaseViewEntity, DatabaseViewVo databaseView) {
        Set databaseViewParameterConditions;
        HashSet paramNames = Sets.newHashSet();
        Set databaseViewMateDataConditions = databaseView.getDatabaseViewMateDataConditions();
        if (!CollectionUtils.isEmpty((Collection)databaseViewMateDataConditions)) {
            paramNames.addAll(databaseViewMateDataConditions.stream().map(DatabaseViewMateDataConditionVo::getParamName).collect(Collectors.toSet()));
            this.createParametersForMatedata(databaseViewEntity, databaseViewMateDataConditions);
        }
        if (!CollectionUtils.isEmpty((Collection)(databaseViewParameterConditions = databaseView.getDatabaseViewParameterConditions()))) {
            paramNames.addAll(databaseViewParameterConditions.stream().map(DatabaseViewParameterConditionVo::getParamName).collect(Collectors.toSet()));
            this.createParametersForParameter(databaseViewEntity, databaseViewParameterConditions);
        }
    }

    private void createParametersForParameter(DatabaseViewEntity databaseViewEntity, Set<DatabaseViewParameterConditionVo> databaseViewParameterConditions) {
        for (DatabaseViewParameterConditionVo databaseViewParameterCondition : databaseViewParameterConditions) {
            databaseViewParameterCondition.setId(null);
            String targetOpType = databaseViewParameterCondition.getTargetOpType();
            boolean matched = false;
            for (ParameterOperatorBindingStrategy parameterOperatorBindingStrategy : this.parameterOperatorBindingStrateies) {
                if (!StringUtils.equals((CharSequence)parameterOperatorBindingStrategy.getBindType(), (CharSequence)targetOpType)) continue;
                matched = true;
            }
            Validate.isTrue((boolean)matched, (String)"\u521b\u5efa\u65f6\uff0c\u4f20\u5165\u7684\u67e5\u8be2\u53c2\u6570\u5fc5\u987b\u5339\u914d\u4e00\u79cd\u53c2\u6570\u64cd\u4f5c\u7b26\u7b56\u7565(%s)", (Object[])new Object[]{targetOpType});
            String targetFieldName = databaseViewParameterCondition.getTargetFieldName();
            Validate.notBlank((CharSequence)targetFieldName, (String)"\u521b\u5efa\u65f6\uff0c\u5fc5\u987b\u4f20\u5165\u67e5\u8be2\u6761\u4ef6\u7684\u76ee\u6807\u5b57\u6bb5\u4fe1\u606f!!", (Object[])new Object[0]);
            DatabaseViewParameterConditionEntity databaseViewParameterConditionEntity = (DatabaseViewParameterConditionEntity)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)databaseViewParameterCondition, DatabaseViewParameterConditionEntity.class, LinkedHashSet.class, ArrayList.class, new String[0]));
            databaseViewParameterConditionEntity.setDataView(databaseViewEntity);
            databaseViewParameterConditionEntity.setId(null);
            if (StringUtils.isBlank((CharSequence)databaseViewParameterCondition.getTargetAlias())) {
                databaseViewParameterConditionEntity.setTargetAlias("");
            }
            if (StringUtils.isBlank((CharSequence)databaseViewParameterCondition.getTargetTableName())) {
                databaseViewParameterConditionEntity.setTargetTableName("");
            }
            if (StringUtils.isBlank((CharSequence)databaseViewParameterCondition.getTargetFieldName())) {
                databaseViewParameterConditionEntity.setTargetFieldName("");
            }
            if (StringUtils.isBlank((CharSequence)databaseViewParameterCondition.getTargetOpType())) {
                databaseViewParameterConditionEntity.setTargetOpType("");
            }
            this.databaseViewParameterConditionRepository.save((Object)databaseViewParameterConditionEntity);
            databaseViewParameterCondition.setId(databaseViewParameterConditionEntity.getId());
        }
    }

    private void createParametersForMatedata(DatabaseViewEntity databaseViewEntity, Set<DatabaseViewMateDataConditionVo> databaseViewMateDataConditions) {
        Pattern pattern = Pattern.compile("[\\w]+");
        for (DatabaseViewMateDataConditionVo databaseViewMateDataCondition : databaseViewMateDataConditions) {
            databaseViewMateDataCondition.setId(null);
            String valueBindType = databaseViewMateDataCondition.getValueBindType();
            Validate.notBlank((CharSequence)valueBindType, (String)"\u5fc5\u987b\u4f20\u5165\u53c2\u6570\u7ed1\u5b9a\u7c7b\u578b", (Object[])new Object[0]);
            boolean matched = false;
            for (ParameterValueBindingStrategy parameterValueBindingStrategy : this.parameterValueBindingStrateies) {
                if (!StringUtils.equals((CharSequence)parameterValueBindingStrategy.getBindType(), (CharSequence)valueBindType)) continue;
                matched = true;
            }
            Validate.isTrue((boolean)matched, (String)"\u521b\u5efa\u65f6\uff0c\u4f20\u5165\u7684\u67e5\u8be2\u53c2\u6570\u5fc5\u987b\u5339\u914d\u4e00\u79cd\u53c2\u6570\u8f6c\u6362\u7b56\u7565(%s)", (Object[])new Object[]{valueBindType});
            String paramName = databaseViewMateDataCondition.getParamName();
            Validate.notBlank((CharSequence)paramName, (String)"\u521b\u5efa\u65f6\uff0c\u4f20\u5165\u7684\u67e5\u8be2\u53c2\u6570\u540d\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
            Validate.isTrue((boolean)pattern.matcher(paramName).find(), (String)"\u521b\u5efa\u65f6\uff0c\u4f20\u5165\u7684\u67e5\u8be2\u53c2\u6570\u540d\u53ea\u80fd\u662f\u6570\u5b57 + \u82f1\u6587\u5b57\u6bcd + \u201c_\u201d\u7684\u7ec4\u5408\u683c\u5f0f!!", (Object[])new Object[0]);
            String valueType = databaseViewMateDataCondition.getValueType();
            Validate.notBlank((CharSequence)valueType, (String)"\u521b\u5efa\u65f6\uff0c\u67e5\u8be2\u53c2\u6570\u7684\u503c\u7c7b\u578b\u5fc5\u987b\u586b\u5199!!", (Object[])new Object[0]);
            Boolean nullable = databaseViewMateDataCondition.getNullable();
            if (nullable == null) {
                databaseViewMateDataCondition.setNullable(Boolean.valueOf(false));
            }
            DatabaseViewMateDataConditionEntity databaseViewMateDataConditionEntity = (DatabaseViewMateDataConditionEntity)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)databaseViewMateDataCondition, DatabaseViewMateDataConditionEntity.class, LinkedHashSet.class, ArrayList.class, new String[0]));
            databaseViewMateDataConditionEntity.setDataView(databaseViewEntity);
            databaseViewMateDataConditionEntity.setId(null);
            this.databaseViewMateDataConditionRepository.save((Object)databaseViewMateDataConditionEntity);
            databaseViewMateDataCondition.setId(databaseViewMateDataConditionEntity.getId());
        }
    }

    private void createOrder(DatabaseViewEntity databaseViewEntity, DatabaseViewVo databaseView) {
        Set databaseViewOrders = databaseView.getDatabaseViewOrders();
        if (CollectionUtils.isEmpty((Collection)databaseViewOrders)) {
            return;
        }
        for (DatabaseViewOrderVo databaseViewOrder : databaseViewOrders) {
            String targetFieldName = databaseViewOrder.getTargetFieldName();
            Validate.notBlank((CharSequence)targetFieldName, (String)"\u53d1\u73b0\u81f3\u5c11\u4e00\u4e2a\u53ef\u6392\u5e8f\u5b57\u6bb5\u7684\u8bbe\u5b9a\u4fe1\u606f\u4e0d\u6b63\u786e\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        }
        for (DatabaseViewOrderVo databaseViewOrderVo : databaseViewOrders) {
            DatabaseViewOrderEntity databaseViewOrderEntity = (DatabaseViewOrderEntity)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)databaseViewOrderVo, DatabaseViewOrderEntity.class, LinkedHashSet.class, ArrayList.class, new String[0]));
            databaseViewOrderEntity.setDataView(databaseViewEntity);
            databaseViewOrderEntity.setId(null);
            if (StringUtils.isBlank((CharSequence)databaseViewOrderEntity.getTargetAlias())) {
                databaseViewOrderEntity.setTargetAlias("");
            }
            if (StringUtils.isBlank((CharSequence)databaseViewOrderEntity.getTargetTableName())) {
                databaseViewOrderEntity.setTargetTableName("");
            }
            if (StringUtils.isBlank((CharSequence)databaseViewOrderEntity.getTargetFieldName())) {
                databaseViewOrderEntity.setTargetFieldName("");
            }
            if (databaseViewOrderEntity.getDefaultFieldName() == null) {
                databaseViewOrderEntity.setDefaultFieldName(false);
            }
            this.databaseViewOrderRepository.save((Object)databaseViewOrderEntity);
            databaseViewOrderVo.setId(databaseViewOrderEntity.getId());
        }
    }

    private void createExternalQueryFields(DatabaseViewEntity databaseViewEntity, DatabaseViewVo databaseView) {
        Set databaseViewOrders;
        Set databaseViewExternalFields = databaseView.getDatabaseViewExternalFields();
        if (CollectionUtils.isEmpty((Collection)databaseViewExternalFields)) {
            return;
        }
        if (CollectionUtils.isEmpty(this.externalQueryInterceptors)) {
            throw new IllegalArgumentException("\u5f53\u524d\u7cfb\u7edf\u672a\u53d1\u73b0\u4efb\u4f55\u6269\u5c55\u5b57\u6bb5\u62e6\u622a\u5668\u7684\u8bbe\u5b9a\uff0c\u4e0d\u80fd\u6dfb\u52a0\u6269\u5c55\u5b57\u6bb5\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458!!");
        }
        Set currentExternalQueryInterceptorCodes = this.externalQueryInterceptors.stream().map(ExternalQueryInterceptor::code).collect(Collectors.toSet());
        HashSet existingFieldNames = Sets.newHashSet();
        Set databaseViewParameterConditions = databaseView.getDatabaseViewParameterConditions();
        if (!CollectionUtils.isEmpty((Collection)databaseViewParameterConditions)) {
            existingFieldNames.addAll(databaseViewParameterConditions.stream().map(DatabaseViewParameterConditionVo::getTargetFieldName).filter(item -> StringUtils.isNotBlank((CharSequence)item)).distinct().collect(Collectors.toSet()));
        }
        if (!CollectionUtils.isEmpty((Collection)(databaseViewOrders = databaseView.getDatabaseViewOrders()))) {
            existingFieldNames.addAll(databaseViewOrders.stream().map(DatabaseViewOrderVo::getTargetFieldName).filter(item -> StringUtils.isNotBlank((CharSequence)item)).distinct().collect(Collectors.toSet()));
        }
        for (DatabaseViewExternalFieldVo databaseViewExternalFieldVo : databaseViewExternalFields) {
            String currentFieldName = databaseViewExternalFieldVo.getFieldName();
            Validate.notBlank((CharSequence)currentFieldName, (String)"\u4f20\u5165\u7684\u6269\u5c55\u5b57\u6bb5\u540d\uff0c\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
            Validate.isTrue((!existingFieldNames.contains(currentFieldName) ? 1 : 0) != 0, (String)"\u4f20\u5165\u7684\u6269\u5c55\u5b57\u6bb5\u540d\u3010%s\u3011\uff0c\u548cSQL\u4e2d\u8f93\u51fa\u7684\u5b57\u6bb5\u540d\u91cd\u590d\uff0c\u8bf7\u66f4\u6362!!", (Object[])new Object[]{currentFieldName});
            String fieldCnName = databaseViewExternalFieldVo.getFieldCnName();
            Validate.notBlank((CharSequence)fieldCnName, (String)"\u4f20\u5165\u7684\u6269\u5c55\u5b57\u6bb5\u4e2d\u6587\u8bf4\u660e\uff0c\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
            String interceptorCode = databaseViewExternalFieldVo.getInterceptorCode();
            Validate.notBlank((CharSequence)interceptorCode, (String)"\u4f20\u5165\u7684\u6269\u5c55\u5b57\u6bb5\u67e5\u8be2\u62e6\u622a\u5668\u7f16\u53f7\uff0c\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
            Validate.isTrue((boolean)currentExternalQueryInterceptorCodes.contains(interceptorCode), (String)"\u672a\u53d1\u73b0\u7f16\u53f7\u4e3a\u3010%s\u3011\u7684\u6269\u5c55\u5b57\u6bb5\u67e5\u8be2\u62e6\u622a\u5668\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{interceptorCode});
            DatabaseViewExternalFieldEntity databaseViewExternalField = (DatabaseViewExternalFieldEntity)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)databaseViewExternalFieldVo, DatabaseViewExternalFieldEntity.class, LinkedHashSet.class, ArrayList.class, new String[0]));
            databaseViewExternalField.setDataView(databaseViewEntity);
            databaseViewExternalField.setId(null);
            this.databaseViewExternalFieldRepository.save((Object)databaseViewExternalField);
            databaseViewExternalFieldVo.setId(databaseViewExternalField.getId());
        }
    }

    @Transactional
    public DatabaseViewVo update(DatabaseViewVo databaseView) {
        boolean validate = false;
        if (!CollectionUtils.isEmpty(this.viewInfoValidateStrateies)) {
            ViewInfoValidateStrategy matchedViewInfoValidateStrategy = null;
            for (ViewInfoValidateStrategy viewInfoValidateStrategy : this.viewInfoValidateStrateies) {
                if (!viewInfoValidateStrategy.support(false, (AbstractView)databaseView)) continue;
                matchedViewInfoValidateStrategy = viewInfoValidateStrategy;
                break;
            }
            if (matchedViewInfoValidateStrategy != null) {
                matchedViewInfoValidateStrategy.validate(false, (AbstractView)databaseView);
                validate = true;
            }
        }
        Validate.isTrue((boolean)validate, (String)"\u4fee\u6539\u65f6\uff0c\u672a\u53d1\u73b0\u6570\u636e\u89c6\u56fe\u5339\u914d\u7684\u9a8c\u8bc1\u903b\u8f91\uff0c\u6700\u53ef\u80fd\u7684\u60c5\u51b5\u662f\u6570\u636e\u89c6\u56fe\u6e90\u7c7b\u578b\u6ca1\u6709\u586b\u5199!!", (Object[])new Object[0]);
        String id = databaseView.getId();
        DatabaseViewEntity currentDatabaseView = this.databaseViewRepository.findDetailsById(id);
        Validate.notNull((Object)((Object)currentDatabaseView), (String)"\u4fee\u6539\u65f6\uff0c\u672a\u627e\u5230\u6307\u5b9a\u7684\u6570\u636e\u5e93\u67e5\u8be2\u89c6\u56fe\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        currentDatabaseView.setName(databaseView.getName());
        String databaseCode = databaseView.getDatasouceCode();
        String tenantCode = TenantUtils.getTenantCode();
        DataSourceEntity databaseSource = null;
        if (StringUtils.isNotBlank((CharSequence)databaseCode)) {
            databaseSource = this.dataSourceRepository.findByCodeAndTenantCode(databaseCode, tenantCode);
            Validate.notNull((Object)((Object)databaseSource), (String)"\u521b\u5efa\u65f6\uff0c\u672a\u627e\u5230\u6570\u636e\u5e93\u8bbe\u7f6e\u4fe1\u606f!!", (Object[])new Object[0]);
        }
        currentDatabaseView.setDataSource(databaseSource);
        currentDatabaseView.setSourceSql(databaseView.getSourceSql());
        this.databaseViewRepository.save((Object)currentDatabaseView);
        this.databaseViewMateDataConditionRepository.deleteByDataView(currentDatabaseView.getId());
        this.databaseViewParameterConditionRepository.deleteByDataView(currentDatabaseView.getId());
        this.databaseViewParameterConditionRepository.flush();
        this.createQueryCondition(currentDatabaseView, databaseView);
        this.databaseViewOrderRepository.deleteByDataView(currentDatabaseView.getId());
        this.databaseViewOrderRepository.flush();
        this.createOrder(currentDatabaseView, databaseView);
        this.databaseViewExternalFieldRepository.deleteByDataView(currentDatabaseView.getId());
        this.databaseViewExternalFieldRepository.flush();
        this.createExternalQueryFields(currentDatabaseView, databaseView);
        return databaseView;
    }

    @Transactional
    public void delete(String europaCode, String tenantCode) {
        Validate.isTrue((!StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{europaCode, tenantCode}) ? 1 : 0) != 0, (String)"\u5220\u9664\u65f6\uff0c\u53d1\u73b0\u4f20\u5165\u7684\u53c2\u6570\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        DatabaseViewEntity databaseView = this.databaseViewRepository.findByEuropaCodeAndTenantCode(europaCode, tenantCode);
        Validate.notNull((Object)((Object)databaseView), (String)"\u5220\u9664\u65f6\uff0c\u672a\u53d1\u73b0\u6307\u5b9a\u7684\u6570\u636e\u89c6\u56fe\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        this.databaseViewMateDataConditionRepository.deleteByDataView(databaseView.getId());
        this.databaseViewParameterConditionRepository.deleteByDataView(databaseView.getId());
        this.databaseViewExternalFieldRepository.deleteByDataView(databaseView.getId());
        this.databaseViewOrderRepository.deleteByDataView(databaseView.getId());
        this.databaseViewOrderRepository.flush();
        this.databaseViewRepository.delete((Object)databaseView);
    }

    public DatabaseViewVo findByEuropaCodeAndTenantCode(String europaCode, String tenantCode) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{europaCode, tenantCode})) {
            return null;
        }
        DatabaseViewEntity databaseView = this.databaseViewRepository.findByEuropaCodeAndTenantCode(europaCode, tenantCode);
        if (databaseView == null) {
            return null;
        }
        DatabaseViewVo databaseViewVo = (DatabaseViewVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)databaseView, DatabaseViewVo.class, LinkedHashSet.class, ArrayList.class, new String[]{"databaseViewMateDataConditions", "databaseViewParameterConditions", "databaseViewOrders", "databaseViewExternalFields"});
        DataSourceEntity databaseSourceEntity = databaseView.getDataSource();
        if (databaseSourceEntity == null) {
            databaseViewVo.setDatasouceCode(null);
        } else {
            databaseViewVo.setDatasouceCode(databaseSourceEntity.getCode());
        }
        Set currentParameterConditions = databaseViewVo.getDatabaseViewParameterConditions();
        if (!CollectionUtils.isEmpty((Collection)currentParameterConditions)) {
            List sorted = currentParameterConditions.stream().sorted((s, t) -> StringUtils.compare((String)s.getConditionName(), (String)t.getConditionName())).collect(Collectors.toList());
            databaseViewVo.setDatabaseViewParameterConditions((Set)Sets.newLinkedHashSet(sorted));
        }
        return databaseViewVo;
    }
}

