/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.europa.database.local.validate;

import com.alibaba.druid.pool.DruidDataSource;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.europa.database.sdk.strategy.DataSourceValidateAndBuildStrategy;
import com.bizunited.nebula.europa.database.sdk.vo.DataSourceVo;
import com.bizunited.nebula.security.sdk.password.Aes2PasswordEncoder;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MysqlDataSourceValidateAndBuildStrategy
implements DataSourceValidateAndBuildStrategy {
    @Autowired
    private Aes2PasswordEncoder passwordEncoder;
    private static final String MESS_MYSQL = "mysql";
    private static final String MESS_MYSQL_DRIVER = "com.mysql.cj.jdbc.Driver";
    private static final Logger LOGGER = LoggerFactory.getLogger(MysqlDataSourceValidateAndBuildStrategy.class);

    public String database() {
        return MESS_MYSQL;
    }

    public String databaseDesc() {
        return "MySQL\u6570\u636e\u5e93";
    }

    public boolean matched(DataSourceVo dataSource) {
        String type = dataSource.getType();
        return StringUtils.equalsIgnoreCase((CharSequence)type, (CharSequence)MESS_MYSQL);
    }

    public void validate(DataSourceVo dataSource) {
        String address = dataSource.getAddress();
        Validate.notBlank((CharSequence)address, (String)"\u8fdb\u884c\u64cd\u4f5c\u65f6\uff0c\u5fc5\u987b\u4f20\u5165\u6570\u636e\u5e93\u8fde\u63a5\u5730\u5740\uff08IP\u6216\u8005\u57df\u540d\u90fd\u53ef\uff09", (Object[])new Object[0]);
        String dbName = dataSource.getDbName();
        Validate.notBlank((CharSequence)dbName, (String)"\u8fdb\u884c\u64cd\u4f5c\u65f6\uff0c\u5fc5\u987b\u4f20\u5165\u8fde\u63a5\u7684\u6570\u636e\u5e93\u540d", (Object[])new Object[0]);
        Integer port = dataSource.getPort();
        Validate.notNull((Object)port, (String)"\u6570\u636e\u5e93\u8fde\u63a5\u7aef\u53e3\u5fc5\u987b\u586b\u5199!!", (Object[])new Object[0]);
        String urlParams = dataSource.getUrlParams();
        if (StringUtils.isBlank((CharSequence)urlParams)) {
            dataSource.setUrlParams("");
        }
        String username = dataSource.getUserName();
        Validate.notBlank((CharSequence)username, (String)"\u64cd\u4f5c\u65f6\uff0c\u5fc5\u987b\u4f20\u5165\u6570\u636e\u5e93\u7528\u6237\u540d", (Object[])new Object[0]);
        String type = dataSource.getType();
        Validate.notBlank((CharSequence)type, (String)"\u64cd\u4f5c\u65f6\uff0c\u5fc5\u987b\u4f20\u5165\u6570\u636e\u5e93\u7c7b\u578b\uff08\u76ee\u524d\u53ea\u652f\u6301Mysql\uff09", (Object[])new Object[0]);
        String tenantCode = dataSource.getTenantCode();
        if (StringUtils.isBlank((CharSequence)tenantCode)) {
            dataSource.setTenantCode(TenantUtils.getTenantCode());
        }
        this.checkConnection(dataSource);
    }

    public void checkConnection(DataSourceVo dataSource) {
        try {
            Class.forName(MESS_MYSQL_DRIVER);
        }
        catch (ClassNotFoundException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new IllegalArgumentException(e);
        }
        String username = dataSource.getUserName();
        String password = dataSource.getPassword();
        password = this.passwordEncoder.decode(dataSource.getPassword());
        String url = this.buildUrlFromDataSource(dataSource);
        try {
            Connection conn = DriverManager.getConnection(url, username, password);
            Throwable throwable = null;
            if (conn != null) {
                if (throwable != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                } else {
                    conn.close();
                }
            }
        }
        catch (SQLException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private String buildUrlFromDataSource(DataSourceVo dataSource) {
        if (StringUtils.isBlank((CharSequence)dataSource.getUrlParams())) {
            return String.format("jdbc:mysql://%s:%d/%s", dataSource.getAddress(), dataSource.getPort(), dataSource.getDbName());
        }
        return String.format("jdbc:mysql://%s:%d/%s?%s", dataSource.getAddress(), dataSource.getPort(), dataSource.getDbName(), dataSource.getUrlParams());
    }

    public DruidDataSource buildDataSource(DataSourceVo databaseSourceVo) {
        DruidDataSource dataSource = new DruidDataSource();
        dataSource.setDriverClassName(MESS_MYSQL_DRIVER);
        dataSource.setPoolPreparedStatements(false);
        dataSource.setPassword(databaseSourceVo.getPassword());
        dataSource.setUsername(databaseSourceVo.getUserName());
        dataSource.setUrl(this.buildUrlFromDataSource(databaseSourceVo));
        dataSource.setInitialSize(5);
        dataSource.setMinIdle(2);
        dataSource.setMaxActive(10);
        dataSource.setValidationQuery("select 1");
        dataSource.setTestOnBorrow(true);
        dataSource.setTestWhileIdle(true);
        return dataSource;
    }
}

