/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.europa.database.local.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bizunited.nebula.common.controller.BaseController;
import com.bizunited.nebula.common.controller.model.ResponseModel;
import com.bizunited.nebula.europa.database.sdk.strategy.ExternalQueryInterceptor;
import com.google.common.collect.Lists;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(value="ExternalQueryInterceptorController", tags={"\u6269\u5c55\u67e5\u8be2\u62e6\u622a\u5668\u7684\u67e5\u8be2API"})
@RestController
@RequestMapping(value={"/v1/europa/externalQueryInterceptors"})
public class ExternalQueryInterceptorController
extends BaseController {
    @Autowired(required=false)
    @Lazy
    private List<ExternalQueryInterceptor> externalQueryInterceptors;
    private static final Logger LOGGER = LoggerFactory.getLogger(ExternalQueryInterceptorController.class);

    @ApiOperation(value="\u6309\u7167\u67e5\u8be2\u62e6\u622a\u5668\u7684\u540d\u5b57\u8fdb\u884c\u67e5\u8be2\uff08\u652f\u6301\u6a21\u7cca\u67e5\u8be2\uff09")
    @RequestMapping(value={"/findByName"}, method={RequestMethod.GET})
    public ResponseModel findByName(@RequestParam(value="name") String name) {
        try {
            if (CollectionUtils.isEmpty(this.externalQueryInterceptors)) {
                return this.buildHttpResult();
            }
            ArrayList results = Lists.newArrayList();
            for (ExternalQueryInterceptor externalQueryInterceptor : this.externalQueryInterceptors) {
                if (StringUtils.indexOf((CharSequence)externalQueryInterceptor.name(), (CharSequence)name) == -1) continue;
                results.add(externalQueryInterceptor);
            }
            return this.buildHttpResult(this.buildResutls(results));
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u6309\u7167\u67e5\u8be2\u62e6\u622a\u5668\u7684\u7f16\u53f7\u8fdb\u884c\u67e5\u8be2\uff08\u652f\u6301\u6a21\u7cca\u67e5\u8be2\uff09")
    @RequestMapping(value={"/findByCode"}, method={RequestMethod.GET})
    public ResponseModel findByCode(@RequestParam(value="code") String code) {
        try {
            if (CollectionUtils.isEmpty(this.externalQueryInterceptors)) {
                return this.buildHttpResult();
            }
            ArrayList results = Lists.newArrayList();
            for (ExternalQueryInterceptor externalQueryInterceptor : this.externalQueryInterceptors) {
                if (StringUtils.indexOf((CharSequence)externalQueryInterceptor.code(), (CharSequence)code) == -1) continue;
                results.add(externalQueryInterceptor);
            }
            return this.buildHttpResult(this.buildResutls(results));
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u6309\u7167\u5f53\u524d\u5b50\u7cfb\u7edf\u4e0b\u7684\u6240\u6709\u67e5\u8be2\u62e6\u622a\u5668")
    @RequestMapping(value={"/findAll"}, method={RequestMethod.GET})
    public ResponseModel findAll() {
        try {
            return this.buildHttpResult(this.buildResutls(this.externalQueryInterceptors));
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    private JSONArray buildResutls(List<ExternalQueryInterceptor> externalQueryInterceptors) {
        JSONArray resutls = new JSONArray();
        if (CollectionUtils.isEmpty(externalQueryInterceptors)) {
            return resutls;
        }
        for (ExternalQueryInterceptor externalQueryInterceptor : externalQueryInterceptors) {
            String name = externalQueryInterceptor.name();
            String code = externalQueryInterceptor.code();
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("name", (Object)name);
            jsonObject.put("code", (Object)code);
            resutls.add((Object)jsonObject);
        }
        return resutls;
    }
}

