/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.europa.database.local.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bizunited.nebula.common.controller.BaseController;
import com.bizunited.nebula.common.controller.model.ResponseModel;
import com.bizunited.nebula.europa.database.sdk.strategy.ParameterOperatorBindingStrategy;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(value="ParameterOperatorBindingController", tags={"\u57fa\u4e8e\u6570\u636e\u5e93\u67e5\u8be2\u5b9e\u73b0\u7684\u6570\u636e\u89c6\u56fe\u53ef\u652f\u6301\u7684\u7ed1\u5b9a\u7b56\u7565\u4fe1\u606f"})
@RestController
@RequestMapping(value={"/v1/europa/parameterOperatorBindings"})
public class ParameterOperatorBindingController
extends BaseController {
    @Autowired
    private Set<ParameterOperatorBindingStrategy> parameterOperatorBindingStrategies;
    private static final Logger LOGGER = LoggerFactory.getLogger(ParameterOperatorBindingController.class);

    @ApiOperation(value="\u67e5\u8be2\u5f53\u524d\u6240\u6709\u652f\u6301\u7684\u64cd\u4f5c\u7b26\u4fe1\u606f")
    @RequestMapping(value={"/findAll"}, method={RequestMethod.GET})
    public ResponseModel findAll() {
        try {
            Set sortedParameterOperatorBindingStrategies = this.parameterOperatorBindingStrategies.stream().sorted((s, t) -> {
                String s_bindTypeCnName = s.getBindTypeCnName();
                String t_bindTypeCnName = t.getBindTypeCnName();
                return StringUtils.compare((String)s_bindTypeCnName, (String)t_bindTypeCnName);
            }).collect(Collectors.toSet());
            JSONArray resutls = new JSONArray();
            for (ParameterOperatorBindingStrategy parameterOperatorBindingStrategy : sortedParameterOperatorBindingStrategies) {
                String bindType = parameterOperatorBindingStrategy.getBindType();
                String bindTypeCnName = parameterOperatorBindingStrategy.getBindTypeCnName();
                JSONObject item = new JSONObject();
                item.put("bindType", (Object)bindType);
                item.put("bindTypeCnName", (Object)bindTypeCnName);
                resutls.add((Object)item);
            }
            return this.buildHttpResult(resutls);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u67e5\u8be2\u7279\u5b9a\u7684java class\u80fd\u591f\u4f7f\u7528\u7684\u67e5\u8be2\u6761\u4ef6\u6709\u54ea\u4e9b")
    @RequestMapping(value={"/findByJavaClass"}, method={RequestMethod.GET})
    public ResponseModel findByJavaClass(@RequestParam(value="javaClass") String javaClass) {
        if (StringUtils.isBlank((CharSequence)javaClass)) {
            return this.buildHttpResult();
        }
        try {
            Class<?> currentClass = Class.forName(javaClass);
            Set sortedParameterOperatorBindingStrategies = this.parameterOperatorBindingStrategies.stream().sorted((s, t) -> {
                String s_bindTypeCnName = s.getBindTypeCnName();
                String t_bindTypeCnName = t.getBindTypeCnName();
                return StringUtils.compare((String)s_bindTypeCnName, (String)t_bindTypeCnName);
            }).collect(Collectors.toSet());
            JSONArray resutls = new JSONArray();
            for (ParameterOperatorBindingStrategy parameterOperatorBindingStrategy : sortedParameterOperatorBindingStrategies) {
                String bindType = parameterOperatorBindingStrategy.getBindType();
                String bindTypeCnName = parameterOperatorBindingStrategy.getBindTypeCnName();
                Class[] excludeJavaClasses = parameterOperatorBindingStrategy.excludeJavaClasses();
                boolean isExcluded = false;
                if (excludeJavaClasses != null && excludeJavaClasses.length > 0) {
                    for (Class excludeJavaClass : excludeJavaClasses) {
                        if (!excludeJavaClass.isAssignableFrom(currentClass)) continue;
                        isExcluded = true;
                        break;
                    }
                }
                if (isExcluded) continue;
                JSONObject item = new JSONObject();
                item.put("bindType", (Object)bindType);
                item.put("bindTypeCnName", (Object)bindTypeCnName);
                resutls.add((Object)item);
            }
            return this.buildHttpResult(resutls);
        }
        catch (ClassNotFoundException | RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }
}

