/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.europa.database.local.service.bind;

import com.bizunited.nebula.europa.database.sdk.context.execute.DatabaseExecuteExternalRequest;
import com.bizunited.nebula.europa.database.sdk.context.execute.DatabaseExecuteParameter;
import com.bizunited.nebula.europa.database.sdk.strategy.ParameterValueBindingStrategy;
import com.bizunited.nebula.europa.sdk.context.execute.ExecuteParameter;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.temporal.Temporal;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="DateParamFieldBindingStrategy")
public class DateParamFieldBindingStrategy
implements ParameterValueBindingStrategy {
    private static final String PARAM_BIND_TYPE = "Input_Date";
    private static final String FIELD_FUNC_TYPE = "date_field_convert";
    private static final Logger LOGGER = LoggerFactory.getLogger(DateParamFieldBindingStrategy.class);

    public String getBindType() {
        return PARAM_BIND_TYPE;
    }

    public String getBindTypeCnName() {
        return "\u5916\u90e8\u4f20\u5165\u7684\u65e5\u671f\uff08yyyy-MM-dd\uff09";
    }

    public Boolean getOutside() {
        return true;
    }

    public String getFieldFuncType() {
        return FIELD_FUNC_TYPE;
    }

    public Object bindingFieldValue(ExecuteParameter executeParameter, DatabaseExecuteExternalRequest invokeParamContent) {
        SimpleDateFormat simpleDateFormat;
        Date currentDate;
        DatabaseExecuteParameter databaseExecuteParameter = (DatabaseExecuteParameter)executeParameter;
        String paramName = databaseExecuteParameter.getParamName();
        Object value = invokeParamContent.getAttribute(paramName);
        if (value == null) {
            return null;
        }
        if (value instanceof Date) {
            currentDate = (Date)value;
        } else {
            simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
            try {
                currentDate = simpleDateFormat.parse(value.toString());
            }
            catch (ParseException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
                throw new IllegalArgumentException(e.getMessage(), e);
            }
        }
        simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        return simpleDateFormat.format(currentDate);
    }

    public Class<?>[] matchedJavaClasses() {
        return new Class[]{Date.class, Temporal.class};
    }
}

