package com.bizunited.nebula.europa.database.sdk.context.execute;

import java.util.List;
import java.util.Map;

import org.apache.commons.lang3.Validate;

import com.bizunited.nebula.europa.sdk.context.execute.ExecuteContent;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;

/**
 * 基于数据库查询而实现的数据视图，正式执行到的数据视图内容，存储在这里（包括可能的分页信息）
 * @author yinwenjie
 */
public class DatabaseExecuteContent implements ExecuteContent {

  private Boolean pageable = false;
  
  private Boolean empty = true;
  
  private int totalPages = 1;
  
  private long totalElements = 0;
  
  private int pageNumber = 0;
  
  private int numberOfPage = 50;
  
  private int currentRowNumber = 0;
  
  private List<Map<String, Object>> results;
  
  /**
   * 必须指定查询结果信息的数据行数量
   * @param maxRowNumber 当前查询结果数量，必须大于-1的数量值
   */
  public DatabaseExecuteContent(int currentRowNumber) {
    Validate.isTrue(currentRowNumber >= 0 , "创建数据视图查询内容时，发现错误的查询结果数量值!!");
    this.currentRowNumber = currentRowNumber;
    this.results = Lists.newArrayList();
    if(currentRowNumber > 0) {
      for(int index = 0 ; index < currentRowNumber ; index++) {
        results.add(null);
      }
    }
  }
  
  @Override
  public Boolean getPageable() {
    return this.pageable;
  }

  @Override
  public Boolean getEmpty() {
    return this.empty;
  }

  @Override
  public List<Map<String, Object>> getResults() {
    return this.results;
  }

  @Override
  public int getTotalPages() {
    return this.totalPages;
  }

  @Override
  public long getTotalElements() {
    return this.totalElements;
  }

  @Override
  public int getPageNumber() {
    return this.pageNumber;
  }

  @Override
  public int getNumberOfPage() {
    return this.numberOfPage;
  }

  @Override
  public void setContent(int rowIndex, String fieldName, Object content) {
    Validate.isTrue(rowIndex < this.currentRowNumber , "错误的行索引号");
    Validate.notBlank(fieldName , "错误的列名信息，请检查!!");
    // 如果当前行还没有映射任何内容，则创建一个映射
    Map<String , Object> rowMapping = null;
    if((rowMapping = results.get(rowIndex)) == null) {
      rowMapping = Maps.newLinkedHashMap();
      results.set(rowIndex, rowMapping);
    }
    rowMapping.put(fieldName, content);
  }

  public void setPageable(Boolean pageable) {
    this.pageable = pageable;
  }

  public void setEmpty(Boolean empty) {
    this.empty = empty;
  }

  public void setTotalPages(int totalPages) {
    this.totalPages = totalPages;
  }

  public void setTotalElements(long totalElements) {
    this.totalElements = totalElements;
  }

  public void setPageNumber(int pageNumber) {
    this.pageNumber = pageNumber;
  }

  public void setNumberOfPage(int numberOfPage) {
    this.numberOfPage = numberOfPage;
  }
}
