package com.bizunited.nebula.europa.database.sdk.context.execute;

import java.util.Map;

import org.springframework.data.domain.Pageable;

import com.bizunited.nebula.europa.sdk.context.execute.RequestParameter;
import com.google.common.collect.Maps;

/**
 * 数据视图执行时的外部传参信息都在这里，全部以key-value的方式存在，即使是body中以json表达的内容，也会被分析为这里的key-value结构。</p>
 * 
 * 根据参数传递所使用的http的位置，key一样的信息还会被覆盖。顺序是: </br> 
 * query < parameter < body < head</p>
 * 
 * @author yinwenjie
 */
public class DatabaseExecuteExternalRequest implements RequestParameter {
  /**
   * 已经解析好的各参数映射情况
   */
  private Map<String , Object> attributes = Maps.newHashMap();
  /**
   * 已经解析好的分页请求条件
   */
  private Pageable pageable;
  
  /**
   * 获取从外部请求者获取的参数信息
   * @param parameterName
   * @return
   */
  public Object getAttribute(String parameterName) {
    return attributes.get(parameterName);
  }
  
  public void setAttribute(String parameterName , Object value) {
    this.attributes.put(parameterName, value);
  }
  
  public Pageable getPageable() {
    return this.pageable;
  }
  
  public void setPageable(Pageable pageable) {
    this.pageable = pageable;
  }
}
