package com.bizunited.nebula.europa.database.sdk.context.execute;

import com.bizunited.nebula.europa.sdk.context.execute.ExecuteParameter;

/**
 * 基于数据库查询实现的数据视图，在正式执行时的查询参数信息。这些查询参数信息已经完成了操作符的转换、参数值的绑定等操作
 * @author yinwenjie
 */
public class DatabaseExecuteParameter implements ExecuteParameter {
  /**
   * 参数名，别名 + 参数名 或者 数据表 + 参数名 必须保证唯一
   */
  private String paramName;
  
  /**
   * TODO 枚举化
   * 只可能有两个值：dynamic 和 matedata
   */
  private String resource;
  
  /**
   * 查询条件目标数据表的别名
   */
  private String targetAlias;
  
  /**
   * 查询条件目标数据表（可能没有）
   */
  private String targetTableName;
  
  /**
   * 查询条件的目标字段
   */
  private String targetFieldName;
  
  /**
   * 查询条件的操作符类型，需参考ParameterOperatorBindingStrategy具体策略的支持
   */
  private String targetOpType;
  
  /**
   * 经过某个ParameterOperatorBindingStrategy具体策略构建的操作符表达式信息</br>
   * SQL的拼凑，主要就是依靠将这些targetOpValue信息联合起来</p>
   * 
   * 注意：只有resource为dynamic时，该属性才必须有值；否则该属性没有意义
   */
  private String targetOpValue;
  /**
   * 查询条件的值绑定类型，需要ParameterValueBindingStrategy具体策略构建的支持
   * 注意：只有resource为dynamic时，该属性才必须有值；否则该属性没有意义
   */
  private String valueBindType;
  /**
   * 经过某个ParameterValueBindingStrategy具体策略绑定的最终的参数值
   */
  private Object value;
  public String getParamName() {
    return paramName;
  }
  public void setParamName(String paramName) {
    this.paramName = paramName;
  }
  public String getResource() {
    return resource;
  }
  public void setResource(String resource) {
    this.resource = resource;
  }
  public String getTargetAlias() {
    return targetAlias;
  }
  public void setTargetAlias(String targetAlias) {
    this.targetAlias = targetAlias;
  }
  public String getTargetTableName() {
    return targetTableName;
  }
  public void setTargetTableName(String targetTableName) {
    this.targetTableName = targetTableName;
  }
  public String getTargetFieldName() {
    return targetFieldName;
  }
  public void setTargetFieldName(String targetFieldName) {
    this.targetFieldName = targetFieldName;
  }
  public String getTargetOpType() {
    return targetOpType;
  }
  public void setTargetOpType(String targetOpType) {
    this.targetOpType = targetOpType;
  }
  public String getTargetOpValue() {
    return targetOpValue;
  }
  public void setTargetOpValue(String targetOpValue) {
    this.targetOpValue = targetOpValue;
  }
  public String getValueBindType() {
    return valueBindType;
  }
  public void setValueBindType(String valueBindType) {
    this.valueBindType = valueBindType;
  }
  public Object getValue() {
    return value;
  }
  public void setValue(Object value) {
    this.value = value;
  }
}
