package com.bizunited.nebula.europa.database.sdk.context.matedata;

import com.bizunited.nebula.europa.sdk.context.matedata.MetaDataField;

/**
 * 基于数据库查询实现的元数据结构中，用于描述各查询字段的类。</br>
 * 其中包括“字段所属数据表/别名” 信息，是数据库查询实现中特有的信息
 * @author yinwenjie
 */
public class DatabaseMetaDataField extends MetaDataField {
  private static final long serialVersionUID = -5257543544307494675L;
  /**
   * 字段所属别名
   */
  private String alias;
  /**
   * 字段所属数据表的名字（可能没有）
   */
  private String tableName;
  
  public String getAlias() {
    return alias;
  }
  public void setAlias(String alias) {
    this.alias = alias;
  }
  public String getTableName() {
    return tableName;
  }
  public void setTableName(String tableName) {
    this.tableName = tableName;
  }
}
