package com.bizunited.nebula.europa.database.sdk.context.matedata;

import java.io.Serializable;

/**
 * 执行的预查询分析结果中，对于SQL中参数信息的描述（这些查询信息都是在正式执行时必须传入的条件）；</br>
 * 包括参数信息的名称、java类型，索引位（从1开始）的描述
 * @author yinwenjie
 *
 */
public class DatabaseMetaDataParameter implements Serializable {
  private static final long serialVersionUID = 4610167197212662268L;
  /**
   * 索引位（从1开始）
   */
  private int index;
  /**
   * 参数名(一般来说和元数据中某一个字段信息对应)
   */
  private String parameterName;
  /**
   * 参数的java类型
   */
  private String parameterClassName;
  
  public int getIndex() {
    return index;
  }
  public void setIndex(int index) {
    this.index = index;
  }
  public String getParameterName() {
    return parameterName;
  }
  public void setParameterName(String parameterName) {
    this.parameterName = parameterName;
  }
  public String getParameterClassName() {
    return parameterClassName;
  }
  public void setParameterClassName(String parameterClassName) {
    this.parameterClassName = parameterClassName;
  }
}
