package com.bizunited.nebula.europa.database.sdk.service;

import com.bizunited.nebula.europa.database.sdk.vo.DatabaseViewVo;

/**
 * 基于数据库查询的
 * @author yinwenjie
 */
public interface DatabaseViewVoService {
  /**
   * 对基于数据库查询的数据视图实现，进行数据视图扩展信息的新增
   * @param databaseView 指定的数据视图
   * @return
   */
  public DatabaseViewVo create(DatabaseViewVo databaseView);
  
  /**
   * 对基于数据库查询的数据视图实现，进行数据视图扩展信息的修改
   * @param databaseView
   * @return
   */
  public DatabaseViewVo update(DatabaseViewVo databaseView);
  
  /**
   * 按照指定的二级租户和数据视图基本信息业务编号，查询关联的数据库查询视图，包括关联的查询条件字段信息
   * @param europaCode 需要查询的数据视图基本信息业务编号
   * @param tenantCode 需要查询的二级租户业务编号
   * @return
   */
  public DatabaseViewVo findByEuropaCodeAndTenantCode(String europaCode , String tenantCode);
}
