package com.bizunited.nebula.europa.database.sdk.service;

import javax.persistence.EntityManagerFactory;
import javax.sql.DataSource;

/**
 * 为了简化对SQL的处理，屏蔽不同的数据库类型下SQL的执行细节差异，基于数据库查询实现的数据视图功能中，主要采用JPA组件进行数据库的操作；</p>
 * 所以需要为不同数据库（数据库驱动）、不同数据源的数据库查询准备独立的EntityManager。</p>
 * 注意，虽然使用的是EntityManager，但并不需要为数据库中的数据表定义entity实体，因为整个执行过程最主要的还是使用native sql这部分的功能。</p>
 * 
 * 而该接口解释为了创建不同数据源、不同数据库 对应的entityManager而定义的创建策略</p>
 * 
 * @author yinwenjie
 */
public interface EntityManagerBuildingStrategy {
  /**
   * 当正式进行QueryManagner创建前，该方法首先会被调用，以便确定当前的数据源和数据类型是否被当前QueryManangerBuildingStrategy的实现类所支持
   * @param dataSource 将要创建EntityManager所使用的数据源。
   * @param databaseType 数据库类型：MYSQL/ORACLE
   * @return 如果支持创建，则返回true；其它情况返回false
   */
  public boolean canBuild(DataSource dataSource , String databaseType);
  
  /**
   * 正式的创建过程</br>
   * 请参见：entityManagerFactoryBuilder.dataSource(currentDataSource);
   * @param dataSource
   * @return
   */
  public EntityManagerFactory build(DataSource dataSource);
}
