package com.bizunited.nebula.europa.database.sdk.service;

import java.util.Set;

import com.bizunited.nebula.europa.sdk.context.execute.ExecuteParameter;
import com.bizunited.nebula.europa.sdk.context.matedata.MetaData;
import com.bizunited.nebula.europa.sdk.vo.EuropaInfoVo;

/**
 * 这个接口是基于数据库实现的数据视图在正式执行时的条件参数构建拦截器。</p>
 * 通过拦截器，使用者可以干预正式执行时的条件参数情况，例如增加新的查询条件，去掉不需要的查询条件。这些变化都将体现在最终的数据库查询执行结果上</p>
 * 
 * 要使用该拦截器，使用者至少需要知道基于数据库查询构建的数据视图，在执行时的参数类型：</br>
 * a、参数类型为“matedata”的查询参数，这类型的查询条件是在数据视图创建时，就写死在SQL信息中的，不能改变而且每次执行都必须携带参数值（否则就会报错），例如：</br>
 * select * from u_user u where u.org in(:orgs) </br>
 * 以上语句中， orgs参数就是一个matedata性质的查询参数。每次查询都必须指定这个条件，否则查询就无法执行</p>
 * 
 * b、参数类型为“dynamic”的查询参数，这类型的查询条件是在查询正式执行时，使用者根据自己需要传入的。每次执行可以传入也可以不传入。</br>
 * 而ExecuteParameterBuildInterceptor拦截器能够添加或者移除的查询条件也只有这类参数。</p>
 * 
 * @author yinwenjie
 *
 */
public interface ExecuteParameterBuildInterceptor {
  /**
   * 当基于数据库查询的数据视图，在正式执行之前，该拦截方法将会被触发。开发人员可以在该方法对构造的执行参数集合内的参数信息进行添加、修改或者删除。</p>
   * 
   * 这里要特别注意新增一个查询参数要注意的几个点：</br>
   * 1、新增的查询参数的性质（“resource”属性）只能是dynamic的；</br>
   * 2、新增的查询参数，必须要指定参数名（paramName），且别名 + 参数名 或者 数据表 + 参数名 必须保证唯一
   * 3、新增的查询参数必须要指定别名信息（targetAlias）、数据表信息（targetTableName）和查询字段信息（targetFieldName）</br>
   * 4、新增的查询参数必须要指定查询操作符类型信息（targetOpType），例如"=" , "!=" , "in" 等等，这个信息将在后续的处理过程中帮助该执行参数构建条件表达式。
   * 那么系统中支持哪些查询操作符呢？开发人员可参见系统中所有ParameterOperatorBindingStrategy策略器的实现列表，在每一个实现类的getBindType()方法中，可以找到 </p>
   * 
   * 5、新增的查询参数可以指定值绑定类型信息（bindType），也可以不指定。这个信息会在后续的处理过程中，帮助该查询条件绑定类型正确的真正查询值；
   * 那么系统中支持哪些查询操作符呢？开发人员可参见系统中所有ParameterValueBindingStrategy策略器的实现列表，在每一个实现类的getValueBindType()方法中，可以找到 </br>
   * 如果不指定bindType属性，那么就需要直接指定参数的最终赋值属性value，也就是说bindType属性和value属性必须选择一个进行设定
   * 
   * @param metaData 当前正在被处理的基于数据库查询的数据视图元数据结构（即表头结构）
   * @param europaInfoVo 当前正在被处理的基于数据库查询的数据视图基本信息（包括关联的查询语句设定信息）
   * @param dynamicExecuteParameters 当前已被找到的所有需要加入到查询语句中的动态条件集合（可能为空集合，但绝对不会为null）
   */
  public void onBuildExecuteParameters(final MetaData metaData , final EuropaInfoVo europaInfoVo, final Set<ExecuteParameter> dynamicExecuteParameters);
}
