package com.bizunited.nebula.europa.database.sdk.service;

import java.sql.Connection;
import java.sql.SQLException;

import javax.sql.DataSource;

import com.bizunited.nebula.europa.sdk.context.matedata.MetaData;

/**
 * 因为不同的数据源实现、不同的数据库驱动实现，对元数据结构的解析过程不一样。
 * 所以需要改元数据结构解析器，以便区分不同的数据源、不同的数据库驱动的解析过程</p>
 * 
 * 每一个MetaDataResolver解析器的实现，负责一种数据源、一种数据库类型（驱动）的元数据结构解析。</p>
 * 
 * 如果在元数据解析过程中，没有找到合适的解析器，则整个解析过程会抛出异常并终止
 * 
 * @author yinwenjie
 */
public interface MetaDataResolver {
  /**
   * 如果当前元数据结构的解析，能够被当前解析器实现所支持，那么返回true；其余情况返回false。
   * @param dataSource
   * @param databaseViewVo
   * @return
   */
  public boolean validate(DataSource dataSource);
  
  /**
   * 如果validate方法返回true，则该解析器的resolver方法会开始运行
   * @param currentConnection 当前已获取的数据库连接，程序员无需关注这个连接的打开和关闭，只需要使用这个连接即可
   * @param sql 存储在数据库图持久层的，由操作者添加的最原始的SQL
   * @return
   */
  public MetaData resolver(Connection currentConnection , String sql) throws SQLException;
}
