package com.bizunited.nebula.europa.database.sdk.service;

import javax.persistence.Query;

/**
 * 当查询条件来源（resource）为dynamics时，就需要为查询参数绑定操作符（例如，大于、小于、不等于、包含等等）；
 * 这些操作符和赋值表达式的关系，就需要由这个绑定策略的具体实现类来进行处理
 * @author yinwenjie
 *
 */
public interface ParameterOperatorBindingStrategy {
  /**
   * 当注册了一种新的操作符绑定方式时，使用该方法返回这种方式唯一操作符:</br>
   * 以便查询操作能正确匹配操作符（例如：>、<、>=、<=）
   */
  public String getBindType();
  /**
   * 当注册了一种新的操作符绑定方式时，使用该方法返回这种方式的中文描述；
   * 以便能够显示在页面上（例如：大于、小于、等于、包括、不包括、不等于。。。）
   */
  public String getBindTypeCnName();
  /**
   * 当查询条件要求的操作符绑定类型和具体实现类getBindType方法返回的字符串一致时，该方法被触发。</br>
   * 开发者需要填写一个表达式，以便帮助查询组合过程，确定该操作符的表达式格式。例如：</p>
   * targetAlias.targetField != :parameterName </p>
   * 
   * @param targetAlias 当前查询条件的目标别名（注意，可能没有值，但建议优先使用该值构建表达式）
   * @param targetTableName 当前查询条件的目标数据表名
   * @param targetField 当前查询条件的目标字段（一定有值）
   * @param parameterName 当前查询条件的参数名
   * @return 返回的表达式，将被拼凑到最终执行的SQL中
   */
  public String expression(String targetAlias ,String targetTableName , String targetField , String parameterName);
  /**
   * 查询条件策略的处理过程，不但要关注操作表达式的书写，还要关注query查询执行时，如何进行查询条件值的绑定问题。
   * @param query 目前正在指定的查询操作
   * @param parameterName 当前需要绑定的参数名
   * @param value 当前需要绑定的查询条件值
   */
  public void expressionBind(Query query , String parameterName , Object value);
}
