package com.bizunited.nebula.europa.database.sdk.service;

import com.bizunited.nebula.europa.database.sdk.context.execute.DatabaseExecuteExternalRequest;
import com.bizunited.nebula.europa.sdk.context.execute.ExecuteParameter;

/**
 * 不同类型的参数绑定到SQL时的方式是不一样的，而且根据参数值的来源不同，值的转换方式可能不一样。</p>
 * 而该策略接口，就是为了定义不同值的来源，并取得参数化值以及进行值的类型转换。</p>
 * @author yinwenjie
 */
public interface ParameterValueBindingStrategy {
  /**
   * 当注册了一种新的查询字段绑定方式时，使用该方法返回这种方式唯一的英文标识
   */
  public String getBindType();
  /**
   * 当注册了一种新的查询字段绑定方式时，使用该方法返回这种方式的中文描述；
   * 以便能够显示在页面上
   */
  public String getBindTypeCnName();
  /**
   * 通过这种参数值绑定策略处理的查询条件，是否可以不由外部传入
   * @return true；表示需要由外部传入；其它值：表示不由外部传入
   */
  public Boolean getOutside();
  /**
   * 该方法进行参数值的转换，注意是转换，不是到SQL中进行值的绑定
   * @param paramFieldVo 
   * @param invokeContext 来源于europa模块的sdk，记录着正式进行数据视图查询调用时，来源于HTTP请求的传参内容
   * @return 
   */
  public Object bindingFieldValue(ExecuteParameter executeParameter , DatabaseExecuteExternalRequest invokeParamContent);
}
