package com.bizunited.nebula.europa.database.sdk.vo;

import com.bizunited.nebula.common.vo.UuidVo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 基于数据库查询的数据视图，对应的查询条件字段描述
 * @author yinwenjie
 */
@ApiModel(description="基于数据库查询的数据视图，对应的查询条件字段描述")
public class DatabaseViewParameterVo extends UuidVo {

  private static final long serialVersionUID = -614155277302534986L;
  
  @ApiModelProperty("参数名（英文），参数名由分析SQL语句时提取。")
  private String paramName;
  
  @ApiModelProperty("参数绑定来源，该值并不固定，由上层服务自行实现")
  private String valueBindType;
  
  @ApiModelProperty("支持：java.lang.String，java.util.Date，和java八大基础类型")
  private String valueType;
  
  @ApiModelProperty("查询条件是否必须由调用者进行外部传入（true：可以不传值；false: 必须传值）")
  private Boolean outside = false;
  
  @ApiModelProperty("查询条件定义来源：matedata：由元数据结构中的固定查询条件最为来源；dynamic：由操作者在界面上或者利用代理器设定的来源")
  private String resource;
  
  @ApiModelProperty("若resource为dynamic，那么该属性记录查询条件绑定的数据表别名")
  private String targetAlias;
  
  @ApiModelProperty("若resource为dynamic，那么该属性记录查询条件绑定的数据表名（可能没有）")
  private String targetTableName;
  
  @ApiModelProperty("若resource为dynamic，那么该属性记录查询条件对应的数据库字段（注意：并不是所有查询条件都需要记录对应的数据库字段）")
  private String targetFieldName;
  
  @ApiModelProperty("若resource为dynamic，那么该属性记录查询条件对应的比较操作符类型")
  private String targetOpType;
  
  public String getParamName() {
    return paramName;
  }
  public void setParamName(String paramName) {
    this.paramName = paramName;
  }
  public String getValueBindType() {
    return valueBindType;
  }
  public void setValueBindType(String valueBindType) {
    this.valueBindType = valueBindType;
  }
  public String getValueType() {
    return valueType;
  }
  public void setValueType(String valueType) {
    this.valueType = valueType;
  }
  public String getTargetOpType() {
    return targetOpType;
  }
  public void setTargetOpType(String targetOpType) {
    this.targetOpType = targetOpType;
  }
  public Boolean getOutside() {
    return outside;
  }
  public void setOutside(Boolean outside) {
    this.outside = outside;
  }
  public String getResource() {
    return resource;
  }
  public void setResource(String resource) {
    this.resource = resource;
  }
  public String getTargetAlias() {
    return targetAlias;
  }
  public void setTargetAlias(String targetAlias) {
    this.targetAlias = targetAlias;
  }
  public String getTargetFieldName() {
    return targetFieldName;
  }
  public void setTargetFieldName(String targetFieldName) {
    this.targetFieldName = targetFieldName;
  }
  public String getTargetTableName() {
    return targetTableName;
  }
  public void setTargetTableName(String targetTableName) {
    this.targetTableName = targetTableName;
  }
}
