package com.bizunited.nebula.europa.database.sdk.vo;

import java.util.Set;

import com.bizunited.nebula.europa.sdk.vo.AbstractView;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 基于数据库查询的数据视图信息描述
 * @author yinwenjie
 */
@ApiModel(description="基于数据库查询的数据视图信息描述")
public class DatabaseViewVo extends AbstractView {
  private static final long serialVersionUID = 5587344842292246069L;
  /**
   * 数据源业务编号
   */
  @ApiModelProperty("数据源业务编号")
  private String databaseCode;
  /**
   * 视图中文名
   */
  @ApiModelProperty("视图中文名")
  private String name;
  /**
   * 原始SQL
   */
  @ApiModelProperty("原始SQL")
  private String sourceSql;
  /**
   * 数据库查询条件的描述
   */
  @ApiModelProperty("数据库查询条件的描述")
  private Set<DatabaseViewParameterVo> databaseViewParameters;
  
  public String getName() {
    return name;
  }
  public void setName(String name) {
    this.name = name;
  }
  public String getSourceSql() {
    return sourceSql;
  }
  public void setSourceSql(String sourceSql) {
    this.sourceSql = sourceSql;
  }
  public Set<DatabaseViewParameterVo> getDatabaseViewParameters() {
    return databaseViewParameters;
  }
  public void setDatabaseViewParameters(Set<DatabaseViewParameterVo> databaseViewParameters) {
    this.databaseViewParameters = databaseViewParameters;
  }
  public String getDatabaseCode() {
    return databaseCode;
  }
  public void setDatabaseCode(String databaseCode) {
    this.databaseCode = databaseCode;
  }
}
