package com.bizunited.nebula.europa.sdk.context.execute;

import java.util.List;
import java.util.Map;

/**
 * 返回的数据视图查询内容
 * @author yinwenjie
 */
public interface ExecuteContent {
  /**
   * 返回当前数据视图的执行结果是否支持分页
   * @return 支持分页则返回true；其它情况返回false
   */
  public Boolean getPageable();
  
  /**
   * 返回当前数据视图的执行结果是否为空，
   * @return
   */
  public Boolean getEmpty();
  /**
   * 该内容，就是返回到前端的最终内容。
   * 请注意，该接口的具体实现者，应该保证Map中的内容是有序的。
   * @return
   */
  public List<Map<String , Object>> getResults();
  /**
   * 返回当前查询结果一共有多少页，如果不支持分页，则返回值为1
   * @return
   */
  public int getTotalPages();
  /**
   * 返回当前查询一共有多少条记录，无论查询结果是否支持分页
   * @return
   */
  public long getTotalElements();
  /**
   * 返回当前查询是整个页面数量的第几页，如果不支持分页，则返回0，
   * 这个返回值不可能大于getTotalPages的返回值
   * @return
   */
  public int getPageNumber();
  
  /**
   * 返回当前数据视图查询的每页最大数据量
   * @return 默认为50
   */
  public int getNumberOfPage();
  
  /**
   * 该方法可以直接设定某一行（index从0开始），某个字段的fieldName的内容</br>
   * 注意：设定返回内容信息，必须是已经存在的内容行号上，但是添加的fieldName列信息可以不存在;</br>
   * 当然如果是新添加的内容列，如果列信息不存在于元数据中，该列在页面上可能还是无法展现
   * @param rowIndex
   * @param fieldName 前提是这个字段列必须在元数据QueryMetaData中存在
   * @param content 这个内容可以是字符串、日期或其它类型的内容，只要他能被序列化就行；当然content信息也可以直接设置为null
   */
  public void setContent(int rowIndex , String fieldName , Object content);
  
}
