package com.bizunited.nebula.europa.sdk.context.matedata;

import java.util.List;

import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

import com.google.common.collect.Lists;

/**
 * 这是查询数据源的默认实现，针对不同的数据视图来源类型，分析出来的预执行结构可能都不一样；
 * 所以不同的数据视图来源，有不同的元数据描述
 * @author yinwenjie
 */
public abstract class AbstractMetaData implements MetaData {
  private static final long serialVersionUID = -611051251540208953L;
  /**
   * 记录了所有字段信息，注意不可能有重复字段
   */
  private List<MetaDataField> metaDataFields = Lists.newArrayList();
  /**
   * 数据来源
   */
  private String sourceType;
  
  public AbstractMetaData(String sourceType) {
    Validate.notBlank(sourceType , "元数据必须设定来源类型");
    this.sourceType = sourceType;
  }
  
  @Override
  public int getFieldCount() {
    return metaDataFields.size();
  }

  @Override
  public MetaDataField getMetaDataField(int index) {
    if(index < 0) {
      return null;
    }
    return this.metaDataFields.get(index);
  }

  @Override
  public MetaDataField getMetaDataField(String fieldName) {
    for (MetaDataField queryField : metaDataFields) {
      String currentFieldName = queryField.getFieldName();
      if(StringUtils.equals(currentFieldName, fieldName)) {
        return queryField;
      }
    }
    return null;
  }

  @Override
  public boolean exsitMetaDataField(String fieldName) {
    for (MetaDataField metaDataField : metaDataFields) {
      String currentFieldName = metaDataField.getFieldName();
      if(StringUtils.equals(currentFieldName, fieldName)) {
        return true;
      }
    }
    return false;
  }

  @Override
  public void setMetaDataField(int index, MetaDataField metaDataField) {
    Validate.notNull(metaDataField , "设定元数据字段结构时，字段基本信息必须传入");
    if(index >= metaDataFields.size()) {
      return;
    }
    this.metaDataFields.set(index, metaDataField);
  }

  @Override
  public void addMetaDataField(int index, MetaDataField queryField) {
    Validate.notNull(queryField , "添加元数据字段结构时，字段基本信息必须传入");
    if(index >= metaDataFields.size()) {
      return;
    }
    this.metaDataFields.add(index, queryField);
  }

  @Override
  public void addMetaDataField(MetaDataField queryField) {
    Validate.notNull(queryField , "添加元数据字段结构时，字段基本信息必须传入！");
    this.metaDataFields.add(queryField);
  }

  @Override
  public String getSourceType() {
    return this.sourceType;
  }

  public List<MetaDataField> getMetaDataFields() {
    return metaDataFields;
  }
}
