package com.bizunited.nebula.europa.sdk.context.matedata;

import java.io.Serializable;

/**
 * 查询元数据，主要包括了查询的每一列的情况。</p>
 * @author yinwenjie
 */
public interface MetaData extends Serializable {
  
  public int getFieldCount();
  
  public MetaDataField getMetaDataField(int index);
  
  public MetaDataField getMetaDataField(String fieldName);
  
  /**
   * 确认指定的元数据字段信息是否存在
   * @param fieldName
   * @return
   */
  public boolean exsitMetaDataField(String fieldName);
  
  /**
   * 在当前元数据描述的所有元数据字段信息的指定索引位，重新设定元数据字段描述
   * @param index
   * @param queryField
   */
  public void setMetaDataField(int index , MetaDataField queryField);
  
  /**
   * 在当前元数据描述的所有元数据字段信息的指定索引位，新增一个元数据字段描述
   * @param index 
   * @param queryField
   */
  public void addMetaDataField(int index , MetaDataField queryField);
  
  /**
   * 在当前元数据描述的所有元数据字段信息的末尾，增加一个新的元数据字段描述
   * @param queryField
   */
  public void addMetaDataField(MetaDataField queryField);
  
  /**
   * 返回当前元数据的数据来源
   * @return
   */
  public String getSourceType();
}
