package com.bizunited.nebula.europa.sdk.context.matedata;

import java.io.Serializable;
import java.util.Map;

import com.google.common.collect.Maps;

/**
 * 元数据字段：既是元数据信息中的一个字段信息秒搜狐。由于查询源头不一样，所以可能记录的内容不一样；</br>
 * 但是最关键的字段名、中文名、java字段类型这些信息是必须要有的</p>
 * 
 * @author yinwenjie
 */
public abstract class MetaDataField implements Serializable {
  /**
   * 
   */
  private static final long serialVersionUID = 7211672518149268484L;
  /**
   * 预查询时，返回列类型信息（注意，不可能为数组或者为集合）
   */
  private String javaClassName;
  /**
   * 预查询时，返回的列名信息
   */
  private String fieldName;
  /**
   * 预查询时，返回的列中文信息
   */
  private String fieldCnName;
  /**
   * 该字段是否在页面展示（默认展示）
   */
  private Boolean display = true;
  /**
   * 预查询时，返回的字段扩展信息（可能根据不同的数据视图来源，扩展信息不一样）
   */
  private Map<String , Object> extendsProperties = Maps.newLinkedHashMap();
   
  public String getJavaClassName() {
    return javaClassName;
  }
  public void setJavaClassName(String javaClassName) {
    this.javaClassName = javaClassName;
  }
  public String getFieldName() {
    return fieldName;
  }
  public void setFieldName(String fieldName) {
    this.fieldName = fieldName;
  }
  public String getFieldCnName() {
    return fieldCnName;
  }
  public void setFieldCnName(String fieldCnName) {
    this.fieldCnName = fieldCnName;
  }
  public Map<String, Object> getExtendsProperties() {
    return extendsProperties;
  }
  public void setProperty(String key , String value) {
    this.extendsProperties.put(key, value);
  }
  public Boolean getDisplay() {
    return display;
  }
  public void setDisplay(Boolean display) {
    this.display = display;
  }
}
