package com.bizunited.nebula.europa.sdk.event;

import com.bizunited.nebula.europa.sdk.vo.EuropaInfoVo;

/**
 * 欧罗巴数据视图发生变化事件的基本监听接口
 * @author yinwenjie
 */
public interface EuropaInfoEventListener {
  /**
   * 当数据视图基本信息被创建过程中，该事件被触发。</br>
   * 注意，是创建过程中，即Europa的数据视图基本信息被成功保存，但是事务还没有提交时</p>
   * 
   * 而该事件的主要订阅者，就是在这个时候，负责保存数据视图的扩展信息。
   * @param europaInfo
   */
  public void onCreate(EuropaInfoVo europaInfo);
  /**
   * 当数据视图基本信息被修改过程中，该事件被触发。</br>
   * 注意，是修改过程中，即Europa的数据视图基本信息被成功修改保存，但是事务还没有提交时</p>
   * 
   * 而该事件的主要订阅者，就是在这个时候，负责修改数据视图的扩展信息。
   * @param europaInfo
   */
  public void onUpdate(EuropaInfoVo europaInfo);
  /**
   * 当数据视图基本信息被禁用时，该事件被触发
   * @param europaInfo
   */
  public void onDisable(EuropaInfoVo europaInfo);
  /**
   * 当数据视图基本信息被启用时，该事件被触发
   * @param europaInfo
   */
  public void onEnable(EuropaInfoVo europaInfo);
}
