package com.bizunited.nebula.europa.sdk.event;

import com.bizunited.nebula.europa.sdk.vo.PersonalizationTemplateVo;

/**
 * 数据视图个性化展示信息的事件监听
 * @author yinwenjie
 */
public interface PersonalizationTemplateEventListener {
  /**
   * 当数据视图个性化展示信息被创建时，该方法被触发
   * @param personalizationTemplate
   */
  public void onCreate(PersonalizationTemplateVo personalizationTemplate);
  /**
   * 当数据视图个性化展示信息被修改时，该方法被触发
   * @param personalizationTemplate
   */
  public void onUpdate(PersonalizationTemplateVo personalizationTemplate);
  
  /**
   * 当数据视图个性化展示信息被删除时，该方法被触发
   * @param personalizationTemplate
   */
  public void onDelete(PersonalizationTemplateVo personalizationTemplate);
}
