package com.bizunited.nebula.europa.sdk.service;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;

import com.alibaba.fastjson.JSONObject;
import com.bizunited.nebula.europa.sdk.dto.EuropaInfoDto;
import com.bizunited.nebula.europa.sdk.vo.EuropaInfoVo;

/**
 * 欧罗巴的主服务，主要用于返回为数据视图的预览执行和正式执行服务的辅助信息。</br>
 * 例如，返回当前系统中已识别的数据视图设定（等）、创建一个新的数据视图设定、修改一个已经存在的数据视图设定（如果其本身允许修改的话）
 * @author yinwenjie
 */
public interface EuropaInfoVoService {
  /**
   * 创建一个新的数据视图设定，注意，这里只有数据视图的基本信息，不包括数据视图的具体实现方式（数据库SQL查询实现、controller层方法的实现等）
   * @param europaInfo 将要创建的数据视图基本信息，注意：由于转换存在抽象对象，所以转换需要在方法内部进行
   * @return 创建后的欧罗巴查询视图将进行返回
   */
  public EuropaInfoVo create(JSONObject europaInfo);
  /**
   * 创建一个新的数据视图设定，这里传入的是一个EuropaInfoVo对象，其它创建原则和create(JSONObject)保持一致
   * @param europaInfo
   * @return
   */
  public EuropaInfoVo create(EuropaInfoVo europaInfo);
  /**
   * 对一个已经存在的数据视图设定进行修改，可参考create方法的注释
   * @param europaInfo 将要修改的数据视图基本信息。
   * @return 修改后的欧罗巴查询视图将进行返回
   */
  public EuropaInfoVo update(JSONObject europaInfo);
  /**
   * 对一个已经存在的数据视图设定进行修改，这里传入的是EuropaInfoVo对象，其它修改原则和update(JSONObject)保持一致
   * @param europaInfo
   * @return
   */
  public EuropaInfoVo update(EuropaInfoVo europaInfo);
  /**
   * 禁用一个数据视图（如果这个数据视图已经是禁用状态，则本次操作不会改变什么）
   * @param id
   */
  public void disable(String id);
  /**
   * 启用一个数据视图（如果这个数据视图已经是启用状态，则本次操作不会改变什么）
   * @param id
   */
  public void enable(String id);
  /**
   * 删除指定的数据视图
   * @param id
   */
  public void delete(String id);
  /**
   * 按照二级租户信息、数据视图基本信息的业务编号，查询执行的数据视图和他所有的关联信息
   * @param tenantCode
   * @param code
   * @return 
   */
  public EuropaInfoVo findByTenantCodeAndCode(String tenantCode , String code);
  /**
   * 数据视图分页查询，目前只实现了一个简单的分页查询（当然是按照当前的二级租户进行查询）
   * @param pageable 
   * @param europaInfoDto 用来描述数据视图分页查询的条件信息
   * @return
   */
  Page<EuropaInfoVo> findByConditions(Pageable pageable , EuropaInfoDto europaInfoDto);
}
