package com.bizunited.nebula.europa.sdk.service;

import org.springframework.data.domain.Pageable;

import com.bizunited.nebula.europa.sdk.context.execute.RequestParameter;
import com.bizunited.nebula.europa.sdk.service.strategy.ExecutionStrategy;
import com.bizunited.nebula.europa.sdk.vo.EuropaInfoVo;
import com.bizunited.nebula.europa.sdk.vo.ExecutionInfo;

public interface ExecutionService {
  /**
   * 请参见execution(String , String ,  Pageable , RequestParameter , ExecutionStrategy) 方法的说明</br>
   * 区别在于，这里传入的是已经查询号的数据视图详细信息，而不是tenantCode和europaInfoCode信息
   */
  public ExecutionInfo execution(EuropaInfoVo europaInfo , Pageable pageable , RequestParameter requestParameter , ExecutionStrategy matchedExecutionStrategy);
  /**
   * 正式执行指定的数据视图，不过不进行内容查询，只是根据各种入参（包括查询条件）返回将会查询得到多少数据行数（条数）
   * @param tenantCode 
   * @param europaInfoCode 
   * @param requestParameter 
   * @return
   */
  public ExecutionInfo executionOnlyCount(String tenantCode , String europaInfoCode , RequestParameter requestParameter, ExecutionStrategy matchedExecutionStrategy);
  /**
   * 正式执行指定的数据视图，不过不进行内容查询，而是进行字段的数据统计
   * @param europaInfo
   * @param requestParameter
   * @param matchedExecutionStrategy
   * @return
   */
  public ExecutionInfo executionStatistic(EuropaInfoVo europaInfo , RequestParameter requestParameter, ExecutionStrategy matchedExecutionStrategy);
  /**
   * 正式执行指定的数据视图，数据视图的执行只能以当前租户为执行范围
   * @param tenantCode 当前执行针对的租户信息
   * @param europaInfoCode 当前执行的europa数据视图的业务编号
   * @param pageable 分页要求信息（注意，排序要求也在里面）
   * @param requestParameter 外部传递的查询要求
   * @param matchedExecutionStrategy 已正确匹配的执行策略，可以不传入，如果不传入将以默认的执行策略为准。如果连默认的执行策略都没有，就抛出异常
   */
  public ExecutionInfo execution(String tenantCode , String europaInfoCode ,  Pageable pageable , RequestParameter requestParameter , ExecutionStrategy matchedExecutionStrategy);
}
