package com.bizunited.nebula.europa.sdk.service;

import java.util.Set;

import com.bizunited.nebula.europa.sdk.vo.PersonalizationTemplateVo;

/**
 * 和欧罗巴数据试图个性化展示相关的sdk服务信息（建议该接口的实现逻辑，支持缓存）</br>
 * 
 * 如果支持缓存，那么至少以下情况，缓存需要清理：</br>
 * 1、当前欧罗巴数据视图默认的样式被修改</br>
 * 2、当前已存在的某个个性化展示样式信息被修改</p>
 * 
 * 注意，既然是清理缓存，就必然需要通知当前系统中的其他进程一同进行清理
 * 
 * @author yinwenjie
 */
public interface PersonalizationTemplateVoService {
  /**
   * 缓存变化订阅的固定键值——通知指定的europaInfoCode
   */
  public static final String EUROPAINFO_CODE_NOTIFY = "_EUROPAINFO_CODE_NOTIFY";
  /**
   * 创建一个新的个性化展示模板信息（注意模板文件地址、文件名要提前进行保存）
   * @param personalizationTemplate
   */
  public void create(PersonalizationTemplateVo personalizationTemplate);
  /**
   * 修改指定的个性化展示模板信息（注意，只能修改特定的一些值）
   * @param personalizationTemplate
   */
  public void update(PersonalizationTemplateVo personalizationTemplate);
  /**
   * 返回当前操作者对某一个数据视图最匹配的（优先级最高的）展示样式模板信息（其它优先级较低的都不会展示）。</br>
   * 如果没有找到任何个性化样式模板信息，则按照指定的欧罗巴数据视图的默认展示样式信息进行返回
   * @param europaInfoCode 指定的欧罗巴数据视图业务编号
   * @return
   */
  public PersonalizationTemplateVo findEffectiveByCurrentUser(String europaInfoCode);
  /**
   * 返回当前操作者对某一个数据视图匹配的所有展示样式模板信息。
   * @param europaInfoCode 指定的欧罗巴数据视图业务编号
   * @return
   */
  public Set<PersonalizationTemplateVo> findDetailsByEuropaInfoCode(String europaInfoCode);
  /**
   * 按照个性化设定信息的业务编号，返回这个个性化设定信息已经关联的所有业务维度信息
   * @param code 指定的个性化设定信息的业务编号（当然要配合当前操作者的二级租户信息）
   * @return 
   */
  public PersonalizationTemplateVo findDetailsByCode(String code);
  /**
   * 当指定的数据视图基本样式信息发生变化，或者其他导致个性化样式信息缓存不再有效，则需要触发该事件，以便所有工作节点能够清理缓存
   * @param tenantCode 指定的二级租户信息
   * @param europaInfoCode 指定的欧罗巴数据视图业务编号
   */
  public void notifyCacheRefresh(String tenantCode , String europaInfoCode);
  /**
   * 基于欧罗巴数据视图业务编号，清除个性化样式缓存
   * @param tenantCode 指定的二级租户信息
   * @param europaInfoCode 指定的欧罗巴数据视图业务编号
   */
  public void clearCache(String tenantCode , String europaInfoCode);
}
