package com.bizunited.nebula.europa.sdk.service;

import com.bizunited.nebula.europa.sdk.context.matedata.MetaData;

/**
 * 数据视图的预执行服务，预执行服务主要用于将指定的SQL、指定的controller层方法等数据来源进行预分析，
 * 并得到初步的分析后的字段信息，以便显示在页面上以后，操作者进行数据视图设定。
 * @author yinwenjie
 */
public interface PreExecutionService {
  /**
   * 欧罗巴数据查询引擎预执行服务
   * @param sourceType 数据源类型，根据数据源类型传入的不同，将由不同的预执行策略进行预执行处理
   * @param content 将要进行预执行的类型，可能是一段SQL，可能是一个controller层方法的名字，还可能是一段JSON信息 
   * @return 
   */
  public MetaData preExecution(String sourceType , String content);
}
