package com.bizunited.nebula.europa.sdk.service.strategy;

import com.bizunited.nebula.europa.sdk.vo.AbstractView;
import com.bizunited.nebula.europa.sdk.vo.EuropaInfoVo;

/**
 * 欧罗巴数据视图基本信息的运维策略，就是负责某种具体实现渠道下数据视图基本信息的增删改查的测了
 * @author yinwenjie
 */
public interface EuropaInfoMaintainStrategy {
  /**
   * 当某个具体的数据视图需要进行数据维护时，该方法会触发，已判定某个具体的运维策略是否适应于本次运维操作
   * @param europaInfoVo 当前正在被运维的数据视图信息
   * @return 如果返回true，说明某个具体的运维策略适合运维本数据视图；其它情况，返回false
   */
  public boolean validate(EuropaInfoVo europaInfoVo);
  
  /**
   * TODO 完善注释
   * @param europaInfoVo
   */
  public void create(EuropaInfoVo europaInfoVo);
  
  /**
   * TODO 完善注释
   * @param europaInfoVo
   */
  public void update(EuropaInfoVo europaInfoVo);
  
  /**
   * TODO 完善注释
   * @param europaInfoVo
   */
  public void delete(EuropaInfoVo europaInfoVo);
  
  /**
   * TODO 完善注释
   * @param sourceType
   * @param europaInfoCode
   */
  public AbstractView request(String sourceType, String europaInfoCode);
}
