package com.bizunited.nebula.europa.sdk.service.strategy;

import com.bizunited.nebula.europa.sdk.context.matedata.MetaData;

/**
 * 预执行策略：预执行策略接口提供给上层模块，以便上层模块能够配合数据视图的预执行过程完成元数据的解析操作。
 * @author yinwenjie
 */
public interface PreExecutionStrategy { 
  /**
   * 该方法判定本次预执行过程是否被特定的预执行策略所支持；
   * @param sourceType 
   * @param content 将要进行预执行的类型，可能是一段SQL，可能是一个controller层方法的名字，可能是一段JSON信息
   * @return 如果支持，则返回true；其它情况返回false
   */
  public boolean validate(String sourceType , String content);
  /**
   * 如果特定的预执行策略返回true，则该执行策略的preExecution方法将被触发。
   * @param sourceType 数据源类型，根据数据源类型传入的不同，将由不同的预执行策略进行预执行处理
   * @param content 将要进行预执行的类型，可能是一段SQL，可能是一个controller层方法的名字，可能是一段JSON信息
   * @return 预执行后的结果将封装成一个QueryMetaData查询元数据进行返回，这个查询元数据将被送入到可能存在的多个拦截器中进行后续执行
   */
  public MetaData preExecution(String sourceType , String content);
} 
