package com.bizunited.nebula.europa.sdk.strategy;

import com.bizunited.nebula.europa.sdk.vo.AbstractView;

/**
 * 具体的欧罗巴实现模型的注册机制，以便查询视图在创建、保存时进行反序列化操作（参见EuropaInfoVo中的view属性,和EuropaInfoVo中的sourceType属性）</p>
 * 
 * 这句话可以这样理解：欧罗巴数据视图可以有多种实现方式，例如使用数据库查询SQL进行数据视图实现，再例如只用一个Spring MVC接口作为数据视图的实现；
 * 而不同的数据视图具体查询实现的模型可能具有不同的属性，那么就需要一个解析转换策略，来进行具体数据视图模型的解析转换。</p>
 * 
 * @author yinwenjie
 */
public interface ViewInfoConvertStrategy {
  /**
   * 该方法在对象转换时，想控制者返回该具体的查询视图转换策略适用于那种sourceType
   */
  public String matchedSourceType();
  /**
   * 返回具体的欧罗巴实现模型
   * @return
   */
  public Class<? extends AbstractView> getAbstractViewClass();
}
