package com.bizunited.nebula.europa.sdk.strategy;

import com.bizunited.nebula.europa.sdk.vo.AbstractView;

/**
 * 当不同形式的数据视图，在进行创建和修改操作时，其数据内部数据的验证/修正策略是不一样的。
 * 实现该策略，将支持对不同形式数据视图在以上操作逻辑中的验证过程
 * @author yinwenjie
 *
 */
public interface ViewInfoValidateStrategy {

  /**
   * 该方法用于确定，某种具体的验证策略，是否对当前的数据视图信息起作用
   * @param isCreate 是否正在进行创建过程
   * @param dataView 将要被验证的，正在进行修改或者创建过程的数据视图 
   * @return true：支持；false：其它情况
   */
  public boolean support(boolean isCreate , AbstractView dataView);
  
  /**
   * 如果support方法返回true，那么该方法将会被触发，程序员可在其中进行具体的验证处理过程
   * @param isCreate 是否正在进行创建过程
   * @param dataView 将要被验证的，正在进行修改或者创建过程的数据视图 
   */
  public void validate(boolean isCreate ,AbstractView dataView);
  
}
