package com.bizunited.nebula.europa.sdk.vo;

import com.bizunited.nebula.common.vo.TenantOpVo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 数据视图基本设定信息描述</p>
 * @author yinwenjie
 */
@ApiModel(description="数据视图基本设定信息描述")
public class EuropaInfoVo extends TenantOpVo {
  private static final long serialVersionUID = 1740504281760310598L;
  /**
   * 子系统信息
   */
  private String subSystem;
  /**
   * 数据视图全系统的唯一编号，tenantCode + code全系统唯一
   */
  @ApiModelProperty("数据视图全系统的唯一编号，tenantCode + code全系统唯一")
  private String code;
  /**
   * 数据视图的中文描述
   */
  @ApiModelProperty("数据视图的中文描述")
  private String name;
  /**
   * 该数据视图是否支持分页操作（一些图形化的报表展示方式是不支持视图结果分页展示的）
   */
  @ApiModelProperty("该数据视图是否支持分页操作")
  private Boolean pageable;
  /**
   * 视图状态: 1:正常；0作废
   */
  @ApiModelProperty("视图状态: 1:正常；0作废")
  private Integer tstatus = 1;
  /**
   * 数据源来源类型</br>
   */
  @ApiModelProperty("数据源来源类型")
  private String sourceType;
  /**
   * 数据视图默认展示文件重命名后的文件名字
   */
  private String fileName;
  /**
   * 数据视图默认展示文件的存储路径，文件在本地的存储目录（相对位置，不包括文件名）
   */
  private String relativeLocal;
  /**
   * 关联的具体查询视图描述信息
   */
  @ApiModelProperty("关联的具体数据视图描述信息")
  private AbstractView view;
  
  public String getSubSystem() {
    return subSystem;
  }
  public void setSubSystem(String subSystem) {
    this.subSystem = subSystem;
  }
  public String getCode() {
    return code;
  }
  public void setCode(String code) {
    this.code = code;
  }
  public String getName() {
    return name;
  }
  public void setName(String name) {
    this.name = name;
  }
  public Boolean getPageable() {
    return pageable;
  }
  public void setPageable(Boolean pageable) {
    this.pageable = pageable;
  }
  public String getSourceType() {
    return sourceType;
  }
  public void setSourceType(String sourceType) {
    this.sourceType = sourceType;
  }
  public String getFileName() {
    return fileName;
  }
  public void setFileName(String fileName) {
    this.fileName = fileName;
  }
  public String getRelativeLocal() {
    return relativeLocal;
  }
  public void setRelativeLocal(String relativeLocal) {
    this.relativeLocal = relativeLocal;
  }
  public AbstractView getView() {
    return view;
  }
  public void setView(AbstractView view) {
    this.view = view;
  }
  public Integer getTstatus() {
    return tstatus;
  }
  public void setTstatus(Integer tstatus) {
    this.tstatus = tstatus;
  }
}
